* static and dynamic allocation results

set more off
capture log close
clear

set matsize 1000

log using logs/summstats.log, replace

* set to 0001 or 05 or 20 or 100 to choose sample to work from
local sampsize = "100"

* what is the base year for static/dynamic allocation
local baseyear = 2008

* results dir
local resultsdir = "results/tabledata"

* which conditions?
global CONDITIONS "ami chf428 pnu hip hipkne"

* which conditions when splitting by ED?
global CONDITIONS_ED "ami chf428 pnu hip"


* do summary stats from the original sample
use counts_allmeas/bs_`sampsize'/bs0.dta, clear
keep if year==`baseyear'

* summary stats - quality

matrix summ_qual = J(33,5,.)
matrix colnames summ_qual = ami chf428 pnu hip hipkne
matrix rownames summ_qual = npats nhosp shareed sharepats sharespend blank blank blank surv_avg surv_sd surv_hosps read_avg read_sd read_hosps blank blank blank usn_spec usn_shelig blank blank blank poc_avg poc_sd poc_hosps poc_nmeas blank blank blank hcahps_avg hcahps_sd hcahps_hosps hcahps_qs

* calculate share of all medicare patients in the categories

* load 2008 medpar
preserve
use prvdrnum dschrgdt admsndt loscnt AGE_CNT DGNSCD1 PRCDRCD* sslssnf ghopdcd drgprice outlramt ER_AMT ///
	using ~/medicare_bulk/sacarny/medpar/medpar_2008, clear

* note all CAH are considered long-stay (`stay'=="L") due to some legislative quirk
gen four = substr(prvdrnum ,3,4)
destring four, force replace
gen cah = four != . & four >= 1300 & four <= 1399

* keep only short-stay claims OR cah claims
* FIXME: is there a way to drop swing bed stays in CAH?
keep if sslssnf=="S" | cah==1
drop sslssnf

* drop GHO (HMO) paid claims
drop if ghopdcd=="1"
drop ghopdcd

* impute discharge date when blank
replace dschrgdt = admsndt + loscnt if dschrgdt == .
assert dschrgdt != .
gen dis_yr = year(dschrgdt)
drop dschrgdt admsndt loscnt

* total spending is drg price + outlier payment
gen spend = drgprice + outlramt
drop drgprice outlramt

* only 2008 discharges
drop if dis_yr != 2008
drop dis_yr

* want only people 65+
keep if AGE_CNT >= 65
drop AGE_CNT

* bring in CCS categories
rename DGNSCD1 code
merge m:1 code using misc/icd9-cc-mcc.dta, ///
	keepusing(ccs) keep(master match) nogenerate

* AMI is CCS category 100
gen nami = ccs==100
* CHF is CCS category 108
gen nchf428 = ccs==108
* pnumonia is CCS 122
gen npnu = ccs==122
* hip fracture is CCS 226
gen nhip = ccs==226
tab code if ccs==226

* hip/knee replacement is procedure code 81.51 or 81.54 in any procedure code slot
gen nhipkne = 0
forvalues i = 1/6 {
	replace nhipkne = 1 if PRCDRCD`i'=="8151"|PRCDRCD`i'=="8154"
}

* thru ed indicator
gen byte thru_ed = ER_AMT>0

* rebase to pn_new identifier so we can count unique hospitals
rename prvdrnum pn
merge m:1 pn using dartmouth_xwlk/pn2pn_new.dta, ///
	keep(master match) generate(match_dxwlk)
rename pn pn_old

display "Observations that did not match to dartmouth crosswalk to pn_new (dropping):"
count if match_dxwlk==1
drop if match_dxwlk==1
drop match_dxwlk

* variables for tallying spending and patient counts by condition
foreach cond in ami chf428 pnu hip hipkne {
	gen s`cond' = n`cond'*spend
	
	gen n`cond'Xed = n`cond'*thru_ed
}

gen npatients = 1

gen noverlap = nhipkne & (nami|nchf428|npnu|nhip)
gen soverlap = noverlap*spend

* hospital level counts of patients and sums of spending
collapse (sum) n* s*, by(pn_new) fast

* variables for tallying number of hospitals with at least one patient
foreach cond in ami chf428 pnu hip hipkne {
	gen byte h`cond' = n`cond'>0 & n`cond'!=.	
}

* national level counts of patients, sums of spending, counts of hospitals
collapse (sum) n* s* h*, fast

list

local c = 1
foreach cond in $CONDITIONS {
	matrix summ_qual[1,`c'] = n`cond'[1] \ h`cond'[1] \ n`cond'Xed[1]/n`cond'[1] \ n`cond'[1]/npatients[1] \ s`cond'[1]/spend[1]
	local c = `c' + 1
}

list

display "share patients overlapping hip/knee rpl and ami/chf/pnu/hipfrac:"
display noverlap[1]/npatients[1]

display "share $ overlapping:"
display soverlap[1]/spend[1]

restore

local c = 1
foreach cond in $CONDITIONS {
	display "***** WORKING ON `cond' *****"
	
	* survival and readmission

	* survival rate
	if (regexm("`cond'","^(ami|chf428|pnu|hip)$")) {
		* avg survival rate across hospitals (do this with no risk adjustment --
		* the avg for risk-adjusted survival is for a patient with all zeroes for
		* the risk adjusters)
		summ snra_`cond'_fe if insamp_`cond'_tot
		matrix summ_qual[9,`c'] = r(mean)
		local nhosp = r(N)	
		* underlying sd
		summ surv_`cond'_uvar
		matrix summ_qual[10,`c'] = -sqrt(r(mean))
		* nhospitals
		summ surv_`cond'_eb
		matrix summ_qual[11,`c'] = r(N)
		* should be the same
		assert `nhosp'==r(N)
	}

	* readmission rate
	* avg readm rate across hospitals (do this with no risk adjustment --
	* the avg for risk-adjusted readm is for a patient with all zeroes for
	* the risk adjusters)
	summ rnra_`cond'_fe if insamp_`cond'_tot
	matrix summ_qual[12,`c'] = r(mean)
	local nhosp = r(N)	
	* underlying sd
	summ read_`cond'_uvar
	matrix summ_qual[13,`c'] = -sqrt(r(mean))
	* nhospitals
	summ read_`cond'_eb
	matrix summ_qual[14,`c'] = r(N)
	assert `nhosp'==r(N)

	* US news

	if ("`cond'"=="ami" | "`cond'"=="chf428") {
		local usnspec = "heart"
	}
	else if ("`cond'"=="pnu") {
		local usnspec = "resp"
	}
	else if ("`cond'"=="hip" | "`cond'"=="hipkne") {
		local usnspec = "ortho"
	}
	else {
		local usnspec = ""
	}

	summ `usnspec'_eligible if insamp_`cond'_tot
	matrix summ_qual[18,`c'] = r(mean)

	* process of care measures

	* FIXME: should limit stats to sample of hospitals that will ultimately appear in the
	* allocation regressions

	if (regexm("`cond'","^(ami|chf428|pnu)$")) {
		* avg of raw poc measures
		summ poc_`cond'_rawavg if insamp_`cond'_tot
		matrix summ_qual[23,`c'] = r(mean) \ -r(sd) \ r(N)
		local nhosp = r(N)

		* number of measures reported
		summ poc_`cond'_nmeas if poc_`cond'_nmeas>0 & insamp_`cond'_tot
		matrix summ_qual[26,`c'] = r(mean)
		* should be the same # of hospitals in these two variables
		assert r(N)==`nhosp'
	}

	* hcahps

	* stats on overall score
	summ hcahps_overall_score_raw if insamp_`cond'_tot
	matrix summ_qual[30,`c'] = r(mean) \ -r(sd) \ r(N)
	local nhosp = r(N)
	* no of questions answered
	summ hcahps_questions if hcahps_questions > 0 & insamp_`cond'_tot
	matrix summ_qual[33,`c'] = r(mean)
	* should have same no of hosps
	assert `nhosp'==r(N)

	local c = `c' + 1
}


putexcel A1=matrix(summ_qual, names) using `resultsdir'/summ_qual`sampsize'.xlsx, replace
putexcel ///
	B20=("Heart") C20=("Heart") ///
	D20=("Respiratory") ///
	E20=("Orthopedics") F20=("Orthopedics") ///
	using `resultsdir'/summ_qual`sampsize'.xlsx, modify


* summary stats - distance and allocation

matrix summ_alloc = J(19,5,.)
matrix colnames summ_alloc = ami chf428 pnu hip hipkne
matrix rownames summ_alloc = median_dist mean_dist sd_dist trmean_dist shnearest shrr totpats blank blank blank npats sd hosps blank blank blank growth sd hosps
local c = 1
foreach cond in $CONDITIONS {
	display "***** WORKING ON `cond' *****"

	* NOTE limiting to hospitals with risk-adjusted survival (readmission for hip/knee)

	if ("`cond'"=="hipkne") {
		local restrict_str "read_`cond'_eb!=."
	}
	else {
		local restrict_str "surv_`cond'_eb!=."
	}

	* patient count from allocation metric
	qui summ npatients_`cond'_tot if insamp_`cond'_tot & `restrict_str'
	local totpatients = r(sum)


	* distance stats - go to patient level data
	
	preserve

	* want patients at static allocation sample hospitals (w/ valid survival [or
	* readmission for hip/knee]) in base year 
	keep if insamp_`cond'_tot & year==`baseyear' & `restrict_str'
	* merge in patient level data 
	keep pn_preboot year
	duplicates drop
	rename pn_preboot pn
	merge 1:m pn year using processed_events/`cond'`sampsize'.dta, ///
		keepusing(ed noned dist chose_closest samehrr) keep(match)
	rename pn pn_preboot
	count
	assert r(N)==`totpatients'

	qui summ dist, detail
	matrix summ_alloc[1,`c'] = r(p50)
	matrix summ_alloc[2,`c'] = r(mean)
	matrix summ_alloc[3,`c'] = r(sd)

	* trimmed mean
	qui summ dist if dist>=r(p5) & dist<=r(p95)
	matrix summ_alloc[4,`c'] = r(mean)

	* closest hospital
	qui summ chose_closest
	matrix summ_alloc[5,`c'] = r(mean)

	* share in HRR
	qui summ samehrr
	matrix summ_alloc[6,`c'] = r(mean)

	* total patients
	matrix summ_alloc[7,`c'] = r(N)

	restore
	
	* stats on static allocation

	summ npatients_`cond'_tot if insamp_`cond'_tot & `restrict_str', detail
	matrix summ_alloc[11,`c'] = r(mean)
	matrix summ_alloc[12,`c'] = r(sd)
	matrix summ_alloc[13,`c'] = r(N)

	* stats on dynamic allocation

	summ growth_`cond'_tot if insamp_`cond'_tot & `restrict_str', detail
	matrix summ_alloc[17,`c'] = r(mean)
	matrix summ_alloc[18,`c'] = r(sd)
	matrix summ_alloc[19,`c'] = r(N)

	local c = `c' + 1
}
putexcel A1=matrix(summ_alloc, names) using `resultsdir'/summ_alloc`sampsize'.xlsx, replace



* correlation matrix - by condition

foreach cond in ami chf428 pnu {

	matrix corr_cond = J(10,5,.)

	matrix colnames corr_cond = ras rar usn poc hcahps
	matrix rownames corr_cond = ras N rar N usn N poc N hcahps N
	local r = 1
	foreach rowvar of varlist surv_`cond'_fe read_`cond'_fe heart_ranking poc_`cond'_std hcahps_std {

		local c = 1
		foreach colvar of varlist surv_`cond'_fe read_`cond'_fe heart_ranking poc_`cond'_std hcahps_std {
	
			if (`c'<=((`r'+1)/2)) {
		
				if ("`rowvar'"=="heart_ranking"|"`colvar'"=="heart_ranking") {
					local cmd = "spearman"
				}
				else {
					local cmd = "correl"
				}
			
				* calculate correlation
				`cmd' `rowvar' `colvar' if insamp_`cond'_tot
				local rho = r(rho)
				local N = r(N)
						
				* adjust for measurement error in survival and readmission rates
				* FIXME: i calculate the SDs etc using the 'simple' method (no weights)
				* but elsewhere in the paper, the measures are adjusted with the interative
				* (weighted) method
				* i think this is the right way to go here because the covariance term is
				* calculated with the simple method. but i'm noting the contrast to the rest of
				* the paper
				foreach meas in surv read {
					if ( ///
						("`rowvar'"=="`meas'_`cond'_fe"|"`colvar'"=="`meas'_`cond'_fe") & ///
						"`cmd'"=="correl" ///
					) {
						display "fixing for measurement error in `meas'"
						* multiply by SD( raw measure ) / [ true SD ]
			
						* SD( raw measure )
						qui summ `meas'_`cond'_fe ///
							if `rowvar'!=.&`colvar'!=. & insamp_`cond'_tot
						assert r(N)==`N'
						local rawsd = r(sd)
						display "raw sd of `meas': `rawsd'"
			
						* [ true SD ]
						* calculate average squared standard error
						tempvar setwo
						gen `setwo' = `meas'_`cond'_se^2
						qui summ `setwo' ///
							if `rowvar'!=. & `colvar'!=. & insamp_`cond'_tot
						assert r(N)==`N'
						drop `setwo'
						* true variance is the raw variance less average squared se
						local truesd = sqrt( `rawsd'^2 - r(mean) )
						display "true sd of `meas': `truesd'"
			
						local rho = `rho'*(`rawsd'/`truesd')
						display "updated rho: `rho'"
					}
				}
			
				* adjust for correlation in measurement error between survival and
				* readmission
				if ( ///
					("`rowvar'"=="surv_`cond'_fe" & "`colvar'"=="read_`cond'_fe") | ///
					("`rowvar'"=="read_`cond'_fe" & "`colvar'"=="surv_`cond'_fe") ///
				) {
					display "fixing for correlated measurement error in surv and read"
				
					* multiply by Cov(raw read, raw surv) / Cov( true read, true surv )
				
					* raw covariance
					correl surv_`cond'_fe read_`cond'_fe if insamp_`cond'_tot, covar
					local rawcov = r(cov_12)
					display "raw covariance of `rowvar' & `colvar': `rawcov'"
					assert r(N)==`N'
				
					* true covariance
					summ surv_read_`cond'_v12 ///
						if surv_`cond'_fe!=. & read_`cond'_fe!=. & insamp_`cond'_tot
					assert r(N)==`N'
					local avgmeaserr = r(mean)
					local truecov = `rawcov' - `avgmeaserr'
					display "true covariance of `rowvar' & `colvar': `truecov'"
				
					display "corr coeff before adjusting for correlated meas err: `rho'"
					local rho = `rho'*(`truecov'/`rawcov')
					display "corr coeff after adjusting for correlated meas err: `rho'"
				
				}
		
				if ("`rowvar'"=="`colvar'") {
					local rho = 1
				}
		
				matrix corr_cond[`r',`c'] = `rho' \ -`N'
						
			}
	
			local c = `c' + 1
		}

		local r = `r' + 2
	}

	putexcel A1=matrix(corr_cond, names) using `resultsdir'/corr_`cond'`sampsize'.xlsx, replace
}

* for hip and knee, the only correlation we need is between readmission and hcahps
matrix corr_cond = J(4,2,.)

matrix colnames corr_cond = rar hcahps
matrix rownames corr_cond = rar N hcahps N

summ read_hipkne_fe if insamp_hipkne_tot
matrix corr_cond[1,1] = 1 \ -r(N)
summ hcahps_std if insamp_hipkne_tot
matrix corr_cond[3,2] = 1 \ -r(N)

correl read_hipkne_fe hcahps_std if insamp_hipkne_tot , covar
matrix C = r(C)
local N = r(N)
local v_read = C[1,1]
local v_hcahps = C[2,2]
local v_hcahps_read = C[2,1]

local correl = `v_hcahps_read'/sqrt(`v_hcahps'*`v_read')
display "raw correlation between HCAHPS and hip/knee readmission"
display `correl'

tempvar setwo
gen `setwo' = read_hipkne_se^2
summ `setwo' if hcahps_std !=. & read_hipkne_fe != . & insamp_hipkne_tot
assert `N'==r(N)
local v_read = `v_read' - r(mean)

local correl = `v_hcahps_read'/sqrt(`v_hcahps'*`v_read')
display "true correlation between HCAHPS and hip/knee readmission"
display `correl'

matrix corr_cond[3,1] = `correl' \ -`N'

putexcel A1=matrix(corr_cond, names) using `resultsdir'/corr_hipkne`sampsize'.xlsx, replace


* correlation matrix - survival, readmission, poc

matrix corr_sr = J(16,11,.)

matrix colnames corr_sr = survpoc_ami survpoc_chf428 survpoc_pnu survpoc_hip blank read_ami read_chf428 read_pnu read_hip read_hipkne
matrix rownames corr_sr = ami N chf428 N pnu N hip N hipnke N ami N chf428 N pnu N

local r = 1
foreach rowcond in $CONDITIONS {
	
	* two subtables, survival and readmission
	local c = 1
	foreach meas in surv read {
		
		* starting column index for this subtable (survival or readmission)
		local coloffset = `c'
		foreach colcond in $CONDITIONS {
	
			display "r `r' c `c'"
			
			* only lower triangle
			if ((`c' - `coloffset' + 1)<=((`r'+1)/2)) {
			
				local rowbase = "`meas'_`rowcond'"
				local colbase = "`meas'_`colcond'"
			
				* dirty hack to prevent the inclusion of any correlation with
				* hip/kne survival

				if ("`rowbase'"!="surv_hipkne" & "`colbase'"!="surv_hipkne") {

					correl `rowbase'_fe `colbase'_fe ///
						if insamp_`rowcond'_tot & insamp_`colcond'_tot

					local rho = r(rho)
					local N = r(N)

					* adjust the correlation for measurement error
					* FIXME: i calculate the SDs etc using the 'simple' method (no weights)
					* but elsewhere in the paper, the measures are adjusted with the interative
					* (weighted) method
					* i think this is the right way to go here because the covariance term is
					* calculated with the simple method. but i'm noting the contrast to the rest of
					* the paper
					foreach modifier in `rowbase' `colbase' {
			
						* multiply by SD( raw measure ) / [ true SD ]
			
						* SD( raw measure )
						qui summ `modifier'_fe ///
							if `rowbase'_fe!=. & `colbase'_fe!=. ///
							 & insamp_`rowcond'_tot & insamp_`colcond'_tot
						assert r(N)==`N'
						local rawsd = r(sd)
						display "raw sd of `modifier': `rawsd'"
			
						* [ true SD ]
						* calculate average squared standard error
						tempvar setwo
						gen `setwo' = `modifier'_se^2
						qui summ `setwo' ///
							if `rowbase'_fe!=. & `colbase'_fe!=. ///
							 & insamp_`rowcond'_tot & insamp_`colcond'_tot
						assert r(N)==`N'
						drop `setwo'
						* true variance is the raw variance less average squared se
						local truesd = sqrt( `rawsd'^2 - r(mean) )
						display "true sd of `modifier': `truesd'"
			
						local rho = `rho'*(`rawsd'/`truesd')
						display "updated rho: `rho'"

					}
			
					if ("`rowbase'"=="`colbase'") {
						local rho = 1
					}

					matrix corr_sr[`r',`c'] = `rho' \ -`N'			
				}
			}

			local c = `c' + 1
		}

	}

	local r = `r' + 2
}

* correlation between process of care scores across conditions

local r = 11
foreach rowcond in ami chf428 pnu {
	
	local c = 1
	foreach colcond in ami chf428 pnu {
		
		if (`c' <= ((`r'-11)/2)+1 ) {
			correl poc_`rowcond'_std poc_`colcond'_std ///
				if insamp_`rowcond'_tot & insamp_`colcond'_tot
		
			matrix corr_sr[`r',`c'] = r(rho) \ -r(N)
		}
		
		local c = `c' + 1
	}
	
	local r = `r' + 2
}


putexcel A1=matrix(corr_sr, names) using `resultsdir'/corr_sr`sampsize'.xlsx, replace

* travel distance for ed/non-ed

matrix travel_ed = J(7,14,.)
matrix colnames travel_ed = ami_ed ami_noned blank chf428_ed chf428_noned blank pnu_ed pnu_noned blank hip_ed hip_noned blank hipkne_ed hipkne_noned
matrix rownames travel_ed = shareed blank median_dist mean_dist sd_dist trmean_dist shnearest

local c = 1
foreach cond in $CONDITIONS {
	display "***** WORKING ON `cond' *****"

	qui summ npatients_`cond'_tot if insamp_`cond'_tot
	local totpatients = r(sum)
	display "total patients: `totpatients'"

	foreach pfx in ed nonedtr {

		* share patients thru ed/noned
		qui summ npatients_`cond'_`pfx' if insamp_`cond'_tot
		local pfxpatients = r(sum)
		matrix travel_ed[1,`c'] = `pfxpatients'/`totpatients'

		display "`pfx' patients: `pfxpatients'"

		* patient level stats - go to patient level data
		preserve

		* want patients at static allocation sample hospitals in base year 
		keep if insamp_`cond'_tot & year==`baseyear'
		* merge in patient level data 
		keep pn_preboot year
		duplicates drop
		
		rename pn_preboot pn
		merge 1:m pn year using processed_events/`cond'`sampsize'.dta, ///
			keepusing(ed noned nonedtr dist chose_closest) keep(match)
		rename pn pn_preboot

		display "count of patients merged to:"
		count
		assert r(N)==`totpatients'
		keep if `pfx'==1
		display "`pfx' patients:"
		count
		assert r(N)==`pfxpatients'

		qui summ dist, detail
		matrix travel_ed[3,`c'] = r(p50) \ r(mean) \ r(sd)

		* trimmed mean
		qui summ dist if dist>=r(p5) & dist<=r(p95)
		matrix travel_ed[6,`c'] = r(mean)

		* closest hospital
		qui summ chose_closest
		matrix travel_ed[7,`c'] = r(mean)

		restore

		local c = `c' + 1
	}

	local c = `c' + 1
}


putexcel A1=matrix(travel_ed, names) using `resultsdir'/travel_ed`sampsize'.xlsx, replace

preserve

* process the management scores

tempfile management

use company_id management using misc/management.dta, clear

* some of the IDs are weirdly coded. fix them

* UPMC shadyside
replace company_id = "US390164" if company_id=="USCMS0271"
* Florida Hospital Celebration Health - reports with Florida Hospital Orlando
replace company_id = "US100007" if company_id=="USCMS0079"
* UPMC shenango - part of UPMC horizon
replace company_id = "US390178" if company_id=="USCMS0269"
* community hospital north
replace company_id = "US150169" if company_id=="USCMS0054"
* central prison hospital -- dropping it
drop if company_id == "USCMS0041"

gen pn = regexr(company_id,"^US","")
replace pn = "0"+pn if length(pn)==5
assert length(pn)==6
drop company_id

* rebase to pn_new identifier
merge m:1 pn using dartmouth_xwlk/pn2pn_new.dta, ///
	keep(master match) generate(match_dxwlk)

display "Observations that did not match to dartmouth crosswalk to pn_new (dropping):"
count if match_dxwlk==1
drop if match_dxwlk==1
drop match_dxwlk

* switch provider identifier
drop pn
rename pn_new pn

* average together multiply surveyed hosps & hospitals that correspond to one synthetic
* id
count
collapse (mean) management, by(pn)
count

save `management'

* process the CMS hospital compare mortality & readmission rates

tempfile cms_mortreadm

use hcompare/mortreadm.dta
keep if year==2008

* rebase to pn_new identifier
merge m:1 pn using dartmouth_xwlk/pn2pn_new.dta, ///
	keep(master match) generate(match_dxwlk)

display "Observations that did not match to dartmouth crosswalk to pn_new (dropping):"
count if match_dxwlk==1
drop if match_dxwlk==1
drop match_dxwlk

* switch provider identifier
drop pn
rename pn_new pn

* generate rates at the synthetic hospital level weighted by npatients
foreach meas in mort readm {
	foreach cond in ami hf pn {
		egen `cond'_`meas'_cms = wtmean(`cond'_`meas'_rate), ///
			weight(`cond'_`meas'_npatients) by(pn)
	}
}

* down to synthetic hospital level
keep pn *_cms
duplicates drop
isid pn

* rename to our name approach
foreach meas in mort readm {
	rename hf_`meas'_cms chf428_`meas'_cms
	rename pn_`meas'_cms pnu_`meas'_cms
}

foreach cond in ami chf428 pnu {
	rename `cond'_readm_cms `cond'_read_cms
}

save `cms_mortreadm'

restore

keep if year==2008
rename pn_preboot pn

merge 1:1 pn using `management', keep(master match) generate(match_management)
merge 1:1 pn using `cms_mortreadm', keep(master match) generate(match_cms_mortreadm)

rename pn pn_preboot

* correlation of quality and management

matrix corr_mgmt = J(8,5,.)

matrix colnames corr_mgmt = ami chf428 pnu hip hipkne
matrix rownames corr_mgmt = ras N rar N poc N hcahps N

local c = 1
foreach cond in $CONDITIONS {
	if ("`cond'"=="ami"|"`cond'"=="chf428"|"`cond'"=="pnu") {
		local measures "surv read poc hcahps"
	}
	else if ("`cond'"=="hip") {
		local measures "surv read hcahps"
	}
	else {
		local measures "read hcahps"
	}
	
	foreach meas in `measures' {
		
		if ("`meas'"=="surv") {
			local r = 1
			local measvar "surv_`cond'_fe"
		}
		else if ("`meas'"=="read") {
			local r = 3
			local measvar "read_`cond'_fe"
		}
		else if ("`meas'"=="poc") {
			local r = 5
			local measvar "poc_`cond'_std"
		}
		else if ("`meas'"=="hcahps") {
			local r = 7
			local measvar "hcahps_std"
		}
		
		correl `measvar' management if insamp_`cond'_tot
		local rho = r(rho)
		local N = r(N)
		
		if ("`meas'"=="surv"|"`meas'"=="read") {
			display "fixing for measurement error in `meas'"
			* multiply by SD( raw measure ) / [ true SD ]

			* SD( raw measure )
			qui summ `meas'_`cond'_fe ///
				if management!=. & `meas'_`cond'_eb!=. & insamp_`cond'_tot
			assert r(N)==`N'
			local rawsd = r(sd)
			display "raw sd of `meas': `rawsd'"

			* [ true SD ]
			* calculate average squared standard error
			tempvar setwo
			gen `setwo' = `meas'_`cond'_se^2
			qui summ `setwo' ///
				if management!=. & `meas'_`cond'_eb!=. & insamp_`cond'_tot
			assert r(N)==`N'
			drop `setwo'
			* true variance is the raw variance less average squared se
			local truesd = sqrt( `rawsd'^2 - r(mean) )
			display "true sd of `meas': `truesd'"

			local rho = `rho'*(`rawsd'/`truesd')
			display "updated rho: `rho'"
			
		}
		
		matrix corr_mgmt[`r',`c'] = `rho' \ -`N'


	}
	
	local c = `c' + 1
}

putexcel A1=matrix(corr_mgmt, names) using `resultsdir'/corr_mgmt`sampsize'.xlsx, replace

matrix corr_cms = J(4,3,.)

matrix colnames corr_cms = ami chf428 pnu
matrix rownames corr_cms = ras N rar N

local c = 1
foreach cond in ami chf428 pnu {

	local r = 1
	foreach meas in mort read {
	
		if ("`meas'"=="mort") {
			tempvar ourmeas
			gen `ourmeas' = 1-surv_`cond'_eb
		}
		else {
			local ourmeas "read_`cond'_eb"
		}
		
		correl `ourmeas' `cond'_`meas'_cms
		matrix corr_cms[`r',`c'] = r(rho) \ -r(N)
		
		local r = `r' + 2
	}
	
	local c = `c' + 1
}

putexcel A1=matrix(corr_cms, names) using `resultsdir'/corr_cms`sampsize'.xlsx, replace

