* static and dynamic allocation results

set more off
capture log close
clear

set matsize 1000

log using logs/alloc-interact.log, replace

* set to 0001 or 05 or 20 or 100 to choose sample to work from
local sampsize = "100"

* what is the base year for static/dynamic allocation
local baseyear = 2008

* results dir
local resultsdir = "results/tabledata"

* which conditions?
global CONDITIONS "ami chf428 pnu hipkne"

* which conditions when splitting by ED?
global CONDITIONS_ED "ami chf428 pnu"

* make the minimum distance file
global MAKEMINDIST = 1

* make the faraway patients file
global MAKEFARAWAY = 1

* bootstrap count
global NBOOT = 0

* use analytic or bootstrapped standard errors
global ANALYTIC = 1

adopath ++ PLUS
adopath ++ ./ado/

if ($ANALYTIC) {
	local stderror "analytic"
}
else {
	local stderror ""
}

* make file w/ with hospital info from POS in pn_new
tempfile pos
use pn pn_new using dartmouth_xwlk/pn2pn_new_extended.dta

* use values from 2008 if possible
gen year = 2008
merge 1:1 pn year using pos/pos.dta, ///
	keepusing( ///
		govt nonprofit forprofit beds_tot urbancbsa typ_control provider_subtype ///
		medaffil resprog_ama resprog_aoa residents ///
	) ///
	keep(master match) generate(match_one)
drop year
* if no match, use values from the last year
merge 1:1 pn using pos/pos_lastyear.dta, ///
	keepusing( ///
		govt nonprofit forprofit beds_tot urbancbsa typ_control provider_subtype ///
		medaffil resprog_ama resprog_ama residents ///
	) ///
	keep(master match match_update match_conflict) ///
	generate(match_two) update

* ought to be a match in at least one of the two files
assert match_one==3 | match_two >= 3

* major medical affiliation
gen byte majormed = medaffil == 1 if medaffil != .
* minor medical affiliation
gen byte minormed = medaffil == 2 | medaffil == 3 if medaffil != .

* academic medical center defined as
* non-federal ownership +
* major medical school affiliation +
* resident program AMA or AOA
gen byte amc = ///
	typ_control != 5 & ///
	majormed & ///
	(resprog_ama | resprog_aoa) ///
	if typ_control!=. & majormed!=. & resprog_ama!=. & resprog_aoa!=.

* teaching facility defined as
* non-federal ownership +
* minor medical school affiliation +
* resident program AMA or AOA
gen byte teaching = ///
	typ_control != 5 & ///
	minormed & ///
	(resprog_ama | resprog_aoa) ///
	if typ_control!=. & minormed!=. & resprog_ama!=. & resprog_aoa!=.
	
* indicator for govt, weighted by number of beds at the hospital
collapse ///
	(mean) govt nonprofit forprofit urbancbsa amc teaching [aw=beds_tot], ///
	by(pn_new)
sort pn_new
save `pos'

clear

* distance to closest hospital for each condition
if ($MAKEMINDIST) {
	use counts_allmeas/bs_`sampsize'/bs0.dta
	keep if year==`baseyear'
	keep pn_preboot insamp_*_tot

	* bring in lat/lon of hospital's zip
	rename pn_preboot pn_new
	merge 1:1 pn_new using dartmouth_xwlk/pn_new.dta, ///
		keep(master match) assert(match using) keepusing(zip) nogenerate
	rename pn_new pn_preboot

	merge m:1 zip using zip2latlon/zip, ///
		keep(master match) keepusing(lat lon src_sas) ///
		generate(match_zip)
	assert match_zip==3 & src_sas==1
	drop match_zip src_sas zip

	* convert to radians
	replace lon = lon*(_pi/180)
	replace lat = lat*(_pi/180)

	* make dataset for hospitals to join to
	tempfile target

	foreach var of varlist pn_preboot lat lon insamp_*_tot {
		rename `var' `var'_target
	}

	sort pn_preboot_target
	save `target'

	* now make the dataset of hospitals to start the join
	foreach var of varlist *_target {
		local pfx = regexr("`var'","_target","_base")
		rename `var' `pfx'
	}

	* cross to target
	cross using `target'

	* drop crosses to same hospital
	drop if pn_preboot_base==pn_preboot_target

	* distance formula from http://www.movable-type.co.uk/scripts/latlong.html
	* "spherical law of cosines"
	* avg radius of earth 3958.756 miles from http://bluemm.blogspot.com/2007/01/excel-formula-to-calculate-distance.html
	gen double dist = acos( sin(lat_target)*sin(lat_base) + cos(lat_target)*cos(lat_base)*cos(lon_base-lon_target) )*3958.756

	* when lat/lons were the same, the above formula returns missing not zero, fix that:
	replace dist = 0 if lat_target==lat_base & lon_target==lon_base
	
	sort pn_preboot_base
	foreach cond in $CONDITIONS {
		gen mindist_`cond' = dist if insamp_`cond'_tot_base & insamp_`cond'_tot_target
	}

	keep pn_preboot_base mindist_*

	collapse (min) mindist_*, by(pn_preboot_base)
	rename pn_preboot_base pn_preboot
	sort pn_preboot
	save misc/mindist.dta, replace
}

if ($MAKEFARAWAY) {

	* count patients >=100 miles away from hospital for each condition
	foreach cond in $CONDITIONS {

		use pn year dist if dist >= 100 using processed_events/`cond'`sampsize'.dta
		gen npatients_`cond'_far = 1
		collapse (sum) npatients_`cond'_far, by(pn year)
		
		sort pn year
		xtset pn year
		
		* an obs for every pn-year
		fillin pn year
		drop _fillin
		replace npatients_`cond'_far = 0 if npatients_`cond'_far==.
		sort pn year

		label var npatients_`cond'_far "patients treated > 100 miles from residence"
		
		* static allocation measure 
		gen lnpatients_`cond'_far = ln(npatients_`cond'_far)
		label var lnpatients_`cond'_far "`cond' static alloc measure - patients >100 miles"

		* dynamic allocation measure
		gen growth_`cond'_far = ///
			(F2.npatients_`cond'_far - npatients_`cond'_far) ///
			/ ///
			( (1/2)*(F2.npatients_`cond'_far + npatients_`cond'_far) )
		label var growth_`cond'_far "`cond' dynamic alloc measure - patients >100 miles - 2 year growth"
		
		keep if year==`baseyear'

		save misc/faraway-`cond'`sampsize'.dta, replace
		clear
	}
	
	* bring together
	clear
	foreach cond in $CONDITIONS {
		if (_N==0) {
			use misc/faraway-`cond'`sampsize'.dta
		}
		else {
			merge 1:1 pn year using misc/faraway-`cond'`sampsize'.dta, nogenerate
		}
		
		rm misc/faraway-`cond'`sampsize'.dta
	}
	
	sort pn year
	save misc/faraway`sampsize'.dta, replace
}

forvalues bsidx=0/$NBOOT {

	use counts_allmeas/bs_`sampsize'/bs`bsidx'.dta
	
	* reduce to base year
	keep if year==`baseyear'
	
	* bring in hospital X's
	rename pn_preboot pn_new
	merge m:1 pn_new using `pos', assert(match using) keep(match) nogenerate
	
	* bring in "far away" patient counts
	rename pn_new pn
	merge 1:1 pn year using misc/faraway`sampsize'.dta, ///
		assert(master match) keep(master match using) nogenerate
	
	rename pn pn_preboot
	
	* bring in min dist to other hospitals
	merge m:1 pn_preboot using misc/mindist.dta, ///
		assert(match using) keep(match) nogenerate
	
	* ln(mindist + 1)
	foreach cond in $CONDITIONS {
		gen lmindistone_`cond' = ln(mindist_`cond'+1)
	}
	
	* bring in HRR-level info
	rename hrrnum_pn_preboot hrrnum
	merge m:1 hrrnum using ../misc/census/hrr_census.dta, ///
		assert(match using) keep(match) keepusing(popdens shcollege) nogenerate
	rename hrrnum hrrnum_pn_preboot

	gen popdenskm2 = popdens*1000000
	gen lpopdenskm2 = ln(popdenskm2)
	
	xtset hrrnum_pn_boot

	* univariate allocation -- only patients >=100 miles from home

	foreach alloc in static dyn {
		display "****** `alloc' results *******"

		foreach cond in $CONDITIONS {
			display "***** WORKING ON `cond' *****"

			if ("`alloc'"=="static") {
				local lhs = "lnpatients_`cond'_far"
			}
			else {
				local lhs = "growth_`cond'_far"
			}
			
			local regsamp = "lnpatients_`cond'_far!=."

			* survival
			if (regexm("`cond'","^(ami|chf428|pnu|hip)$")) {
				xtreg `lhs' surv_`cond'_eb if `regsamp', ///
					fe vce(cluster hrrnum_pn_boot)
				capture mkdir estimates/alloc_faraway/`cond'`sampsize'_surv_`alloc'
				estimates save estimates/alloc_faraway/`cond'`sampsize'_surv_`alloc'/bs`bsidx'.ster, replace
			}
	
			* readmission
			xtreg `lhs' read_`cond'_eb if `regsamp', ///
				fe vce(cluster hrrnum_pn_boot)

			* add some stats about patients to the readmission measure bootstrap 0
			if (`bsidx'==0) {
				* patients in hrr
				qui summ npatients_`cond'_far if insamp_`cond'_tot
				estadd scalar npatients_far = r(sum)
				* patients total
				qui summ npatients_`cond'_tot if insamp_`cond'_tot
				estadd scalar npatients_tot = r(sum)
			}

			capture mkdir estimates/alloc_faraway/`cond'`sampsize'_read_`alloc'
			estimates save estimates/alloc_faraway/`cond'`sampsize'_read_`alloc'/bs`bsidx'.ster, replace
			
			* process of care
			if (regexm("`cond'","^(ami|chf428|pnu)$")) {
				xtreg `lhs' poc_`cond'_std if `regsamp', ///
					fe vce(cluster hrrnum_pn_boot)
				capture mkdir estimates/alloc_faraway/`cond'`sampsize'_poc_`alloc'
				estimates save estimates/alloc_faraway/`cond'`sampsize'_poc_`alloc'/bs`bsidx'.ster, replace
			}

			* readmission
			xtreg `lhs' hcahps_std if `regsamp', ///
				fe vce(cluster hrrnum_pn_boot)
			capture mkdir estimates/alloc_faraway/`cond'`sampsize'_hcahps_`alloc'
			estimates save estimates/alloc_faraway/`cond'`sampsize'_hcahps_`alloc'/bs`bsidx'.ster, replace

		}
	}
	
	* univariate allocation with interactions
	foreach alloc in static dyn {
		display "****** `alloc' results *******"

		foreach cond in $CONDITIONS {
			display "***** WORKING ON `cond' *****"

			if ("`alloc'"=="static") {
				local lhs = "lnpatients_`cond'_tot"
			}
			else {
				local lhs = "growth_`cond'_tot"
			}
			
			local regsamp = "insamp_`cond'_tot"
			
			foreach target in govt mindist shcollege popdens {
				
				if ("`target'"=="mindist") {
					local tvar "lmindistone_`cond'"
				}
				else if ("`target'"=="popdens") {
					local tvar "lpopdenskm2"
				}
				else {
					local tvar "`target'"
				}
	
				* survival
				if (regexm("`cond'","^(ami|chf428|pnu|hip)$")) {
					
					gen interact = surv_`cond'_eb*`tvar'
					
					xtreg `lhs' surv_`cond'_eb interact `tvar' if `regsamp' , ///
						fe vce(cluster hrrnum_pn_boot)
					capture mkdir estimates/alloc_interact/`target'/`cond'`sampsize'_surv_`alloc'
					estimates save estimates/alloc_interact/`target'/`cond'`sampsize'_surv_`alloc'/bs`bsidx'.ster, replace
					
					drop interact
				}
	
				* readmission
				gen interact = read_`cond'_eb*`tvar'
				
				xtreg `lhs' read_`cond'_eb interact `tvar' if `regsamp' , ///
					fe vce(cluster hrrnum_pn_boot)
				capture mkdir estimates/alloc_interact/`target'/`cond'`sampsize'_read_`alloc'
				estimates save estimates/alloc_interact/`target'/`cond'`sampsize'_read_`alloc'/bs`bsidx'.ster, replace
				
				drop interact
				
				* process of care
				if (regexm("`cond'","^(ami|chf428|pnu)$")) {
					gen interact = poc_`cond'_std*`tvar'
					
					xtreg `lhs' poc_`cond'_std interact `tvar' if `regsamp' , ///
						fe vce(cluster hrrnum_pn_boot)
					capture mkdir estimates/alloc_interact/`target'/`cond'`sampsize'_poc_`alloc'
					estimates save estimates/alloc_interact/`target'/`cond'`sampsize'_poc_`alloc'/bs`bsidx'.ster, replace
					
					drop interact
				}
	
				* hcahps
				gen interact = hcahps_std*`tvar'
				
				xtreg `lhs' hcahps_std interact `tvar' if `regsamp' , ///
					fe vce(cluster hrrnum_pn_boot)
				capture mkdir estimates/alloc_interact/`target'/`cond'`sampsize'_hcahps_`alloc'
				estimates save estimates/alloc_interact/`target'/`cond'`sampsize'_hcahps_`alloc'/bs`bsidx'.ster, replace
				
				drop interact
			}
		}
	}
	
	* univariate allocation -- all condition quality measures
	* run it with the full sample for each measure and with the subset of hospitals that
	* reported all measures (except US news)

	foreach alloc in static dyn {
		display "****** `alloc' results *******"

		foreach cond in $CONDITIONS {
			display "***** WORKING ON `cond' *****"

			if ("`alloc'"=="static") {
				local lhs = "lnpatients_`cond'_tot"
			}
			else {
				local lhs = "growth_`cond'_tot"
			}
			
			local regsamp = "insamp_`cond'_tot"

			* survival
			if (regexm("`cond'","^(ami|chf428|pnu|hip)$")) {
				xtreg `lhs' surv_ami_eb surv_chf428_eb surv_pnu_eb if `regsamp', ///
					fe vce(cluster hrrnum_pn_boot)
				capture mkdir estimates/alloc_allcond/`cond'`sampsize'_surv_`alloc'
				estimates save estimates/alloc_allcond/`cond'`sampsize'_surv_`alloc'/bs`bsidx'.ster, replace
			}
	
			* readmission
			xtreg `lhs' read_ami_eb read_chf428_eb read_pnu_eb read_hipkne_eb if `regsamp', ///
				fe vce(cluster hrrnum_pn_boot)
			capture mkdir estimates/alloc_allcond/`cond'`sampsize'_read_`alloc'
			estimates save estimates/alloc_allcond/`cond'`sampsize'_read_`alloc'/bs`bsidx'.ster, replace
			
			* process of care
			if (regexm("`cond'","^(ami|chf428|pnu)$")) {
				xtreg `lhs' poc_ami_std poc_chf428_std poc_pnu_std if `regsamp', ///
					fe vce(cluster hrrnum_pn_boot)
				capture mkdir estimates/alloc_allcond/`cond'`sampsize'_poc_`alloc'
				estimates save estimates/alloc_allcond/`cond'`sampsize'_poc_`alloc'/bs`bsidx'.ster, replace
			}
		}
	}

	* univariate allocation -- controlling for hospital X's

	foreach alloc in static dyn {
		display "****** `alloc' results *******"

		foreach cond in $CONDITIONS {
			display "***** WORKING ON `cond' *****"

			if ("`alloc'"=="static") {
				local lhs = "lnpatients_`cond'_tot"
			}
			else {
				local lhs = "growth_`cond'_tot"
			}
			
			local regsamp = "insamp_`cond'_tot"
			local controls "govt forprofit urbancbsa teaching amc"

			* survival
			if (regexm("`cond'","^(ami|chf428|pnu|hip)$")) {
				xtreg `lhs' surv_`cond'_eb `controls' if `regsamp', ///
					fe vce(cluster hrrnum_pn_boot)
				capture mkdir estimates/alloc_controls/`cond'`sampsize'_surv_`alloc'
				estimates save estimates/alloc_controls/`cond'`sampsize'_surv_`alloc'/bs`bsidx'.ster, replace
			}
	
			* readmission
			xtreg `lhs' read_`cond'_eb `controls' if `regsamp', ///
				fe vce(cluster hrrnum_pn_boot)
			capture mkdir estimates/alloc_controls/`cond'`sampsize'_read_`alloc'
			estimates save estimates/alloc_controls/`cond'`sampsize'_read_`alloc'/bs`bsidx'.ster, replace
			
			* process of care
			if (regexm("`cond'","^(ami|chf428|pnu)$")) {
				xtreg `lhs' poc_`cond'_std `controls' if `regsamp', ///
					fe vce(cluster hrrnum_pn_boot)
				capture mkdir estimates/alloc_controls/`cond'`sampsize'_poc_`alloc'
				estimates save estimates/alloc_controls/`cond'`sampsize'_poc_`alloc'/bs`bsidx'.ster, replace
			}

			* readmission
			xtreg `lhs' hcahps_std `controls' if `regsamp', ///
				fe vce(cluster hrrnum_pn_boot)
			capture mkdir estimates/alloc_controls/`cond'`sampsize'_hcahps_`alloc'
			estimates save estimates/alloc_controls/`cond'`sampsize'_hcahps_`alloc'/bs`bsidx'.ster, replace

		}
	}
	
}

********** write out results **********

* bring in data so i can get underlying SD of quality measures...
use counts_allmeas/bs_`sampsize'/bs0.dta, clear
keep if year==`baseyear'

matrix alloc_allcond = J(27,11,.)
matrix colnames alloc_allcond = ami_static chf428_static pnu_static hip_static hipkne_static blank ami_dyn chf428_dyn pnu_dyn hip_dyn hipkne_dyn
matrix rownames alloc_allcond = surv_ami se surv_chf428 se surv_pnu se N blank blank read_ami se read_chf428 se read_pnu se read_hipkne se N blank blank poc_ami se poc_chf428 se poc_pnu se N

local c = 1
foreach alloc in static dyn {
	display "****** `alloc' results *******"

	foreach cond in $CONDITIONS {
		display "***** WORKING ON `cond' *****"

		* survival
		if (regexm("`cond'","^(ami|chf428|pnu|hip)$")) {
			eboot using estimates/alloc_allcond/`cond'`sampsize'_surv_`alloc', nboot($NBOOT) `stderror'

			summ surv_ami_uvar
			local ami_sd = sqrt(r(mean))
			summ surv_chf428_uvar
			local chf428_sd = sqrt(r(mean))
			summ surv_pnu_uvar
			local pnu_sd = sqrt(r(mean))
			
			matrix alloc_allcond[1,`c'] = ///
				_b[surv_ami_eb]*`ami_sd' \ -_se[surv_ami_eb]*`ami_sd' \ ///
				_b[surv_chf428_eb]*`chf428_sd' \ -_se[surv_chf428_eb]*`chf428_sd' \ ///
				_b[surv_pnu_eb]*`pnu_sd' \ -_se[surv_pnu_eb]*`pnu_sd' \ ///
				e(N)
		}
	
		* readmission
		eboot using estimates/alloc_allcond/`cond'`sampsize'_read_`alloc', nboot($NBOOT) `stderror'

		summ read_ami_uvar
		local ami_sd = sqrt(r(mean))
		summ read_chf428_uvar
		local chf428_sd = sqrt(r(mean))
		summ read_pnu_uvar
		local pnu_sd = sqrt(r(mean))
		summ read_hipkne_uvar
		local hipkne_sd = sqrt(r(mean))
		
		matrix alloc_allcond[10,`c'] = ///
				_b[read_ami_eb]*`ami_sd' \ -_se[read_ami_eb]*`ami_sd' \ ///
				_b[read_chf428_eb]*`chf428_sd' \ -_se[read_chf428_eb]*`chf428_sd' \ ///
				_b[read_pnu_eb]*`pnu_sd' \ -_se[read_pnu_eb]*`pnu_sd' \ ///
				_b[read_hipkne_eb]*`hipkne_sd' \ -_se[read_hipkne_eb]*`hipkne_sd' \ ///
				e(N)
		
		* process of care
		if (regexm("`cond'","^(ami|chf428|pnu)$")) {
			eboot using estimates/alloc_allcond/`cond'`sampsize'_poc_`alloc', nboot($NBOOT) `stderror'
			matrix alloc_allcond[21,`c'] = ///
				_b[poc_ami_std] \ -_se[poc_ami_std] \ ///
				_b[poc_chf428_std] \ -_se[poc_chf428_std] \ ///
				_b[poc_pnu_std] \ -_se[poc_pnu_std] \ ///
				e(N)
		}
	
		local c = `c' + 1
	}
	local c = `c' + 1
}

putexcel A1=matrix(alloc_allcond, names) ///
	using `resultsdir'/alloc_allcond`sampsize'.xlsx, replace

log close

