program eboot, eclass
	
	syntax using/ , Nboot(integer) [ PREfix(string) EXTension(string) ANAlytic COEFFicients(string) ] 
	
	if ("`extension'"=="") {
		local extension "ster"
	}
	
	if ("`prefix'"=="") {
		local prefix "bs"
	}
	
	estimates use `using'/`prefix'0.`extension'
	
	local N = e(N)
	local cmd = e(cmd)
	
	tempname b_original V_original
	
	if ("`coefficients'"!="") {
		* we're only bootstrapping over a few coeffs
		* extract the submatrix of these coefficients and vcov's for them
		
		* bring in the full beta and vcov matrices
		tempname b_original_full V_original_full
		matrix `b_original_full' = e(b)
		matrix `V_original_full' = e(V)
		
		* construct the submatrices that will hold the selected coefficients and their
		* vcovs (from the original run)
		local ncoeff : word count `coefficients'

		matrix `b_original' = J(1,`ncoeff',.)
		matrix rownames `b_original' = y1
		matrix colnames `b_original' = `coefficients'

		matrix `V_original' = J(`ncoeff',`ncoeff',.)
		matrix rownames `V_original' = `coefficients'
		matrix colnames `V_original' = `coefficients'
		
		* copy in coeffs and vcov's into the submatrices
		local c = 1
		foreach col in `coefficients' {
			capture noisily matrix `b_original'[1,`c'] = `b_original_full'[1,"`col'"]
			if (_rc!=0) {
				display "Could not find coefficient `col' in beta matrix of original run"
				error 111
			}
			
			local r = 1
			foreach row in `coefficients' {
				matrix `V_original'[`r',`c'] = `V_original_full'["`row'","`col'"]
				local r = `r' + 1
			}
			
			local c = `c' + 1
		}
		
		matrix drop `b_original_full' `V_original_full'

	}
	else {
		matrix `b_original' = e(b)
		matrix `V_original' = e(V)
	}
	
	// matrix list b_replicates
	
	if ("`analytic'"=="analytic") {
		* use analytic standard errors from the initial run
		ereturn post `b_original' `V_original' , obs(`N')
	}
	else {
		* bootstrap standard errors from the replicates
		tempname b_replicates V_replicates
		matrix `b_replicates' = J(`nboot',colsof(`b_original'),.)	
		matrix `V_replicates' = J(colsof(`b_original'),colsof(`b_original'),.)
		
		* process each replicate
		forvalues bsidx = 1/`nboot' {
			estimates use `using'/`prefix'`bsidx'.`extension'

			tempname b_replicate_full
			matrix `b_replicate_full' = e(b)
			
			if ("`coefficients'"!="") {
				
				* just pull in the chosen coeffs
				local c = 1
				foreach col in `coefficients' {
					capture noisily matrix `b_replicates'[`bsidx',`c'] ///
						= `b_replicate_full'[1,"`col'"]
					if (_rc!=0) {
						display "Could not find coefficient `col' in beta matrix of replicate run `bsidx'"
						error 111
					}
					
					local c = `c' + 1
				}
				
			}
			else {
				* check that we can copy the replicate into the list
				* FIXME: we should check that the colnames are the same!
				if (colsof(`b_replicates')!=colsof(`b_replicate_full')) {
					display "Replicate run `bsidx' has different number of coefficients as original run!"
					display "Did you mean to use the coefficients() option?"
					error 503
				}
				matrix `b_replicates'[`bsidx',1] = e(b)
			}
			
			matrix drop `b_replicate_full'
		}

		mata:replicate_vcov("`b_original'","`V_original'","`b_replicates'","`V_replicates'")
	
		ereturn post `b_original' `V_replicates' , obs(`N')
	}
	
	ereturn local cmd "eboot"
	
	estout , cells("b se t p") style(fixed)
		
end

mata:
void replicate_vcov(string scalar b_original_name, string scalar V_original_name, string scalar b_replicates_name, string scalar V_replicates_name) {

	b_replicates = st_matrix(b_replicates_name)
	V_replicates = variance(b_replicates)
	st_replacematrix(V_replicates_name,V_replicates)
	
	b_colstripe = st_matrixcolstripe(b_original_name)
	st_matrixcolstripe(b_replicates_name,b_colstripe)
	
	V_colstripe = st_matrixcolstripe(V_original_name)
	V_rowstripe = st_matrixrowstripe(V_original_name)
	st_matrixcolstripe(V_replicates_name,V_colstripe)
	st_matrixrowstripe(V_replicates_name,V_rowstripe)
	
}
end
