capture log close
log using "logs/choicemodel.log", replace

set more off
clear

* set to 0001 or 05 or 20 or 100 to choose sample to work from
local sampsize = "100"

* what year do we look at allocation in?
global YEAR = 2008

* results dir
local resultsdir = "results/tabledata"

* run the choice models?
global MAKERESULTS = 1

* which conditions?

global CONDITIONS "ami chf428 pnu hip hipkne"

* bootstrap count
global NBOOT = 0

* use analytic or bootstrapped standard errors
global ANALYTIC = 1

adopath ++ PLUS
adopath ++ ./ado/

if ($ANALYTIC) {
	local stderror "analytic"
}
else {
	local stderror ""
}


if ($MAKERESULTS) {

	foreach cond in $CONDITIONS {
	
		display "***** WORKING ON `cond' *****"

		* set us news specialty
		if ("`cond'"=="ami" | "`cond'"=="chf428") {
			local usnspec = "heart"
		}
		else if ("`cond'"=="pnu") {
			local usnspec = "resp"
		}
		else if ("`cond'"=="hip" | "`cond'"=="hipkne") {
			local usnspec = "ortho"
		}
		else {
			local usnspec = ""
		}
				
		* bring in all the patients from the processed events file
		* limit to the relevant year
		* only patients who stayed in the same HRR
		use diag_id pn samehrr ed noned nonedtr chose_closest ///
			year lat_bene lon_bene hrrnum_pn if year==$YEAR & samehrr==1 ///
			using processed_events/`cond'`sampsize'.dta, clear
		drop year samehrr

		* we have already mimicked the allocation sample restrictions:
		* the year is the base year of analysis [ done ]
		* we've estimated a survival rate (or readmission rate, or other quality measure) for the hospital
		* [ will effectively be made since a hospital w/o measure won't enter
		* sample... ]
		* we observe patients at the hospital in the year (>=1 patient in 2008)
		* [ this will effectively be made since a hospital with no patients doesn't enter
		* the choice model :-) ]
		* note we'll include the tiny % of patients who don't have a valid input 
		* measure. fine i think
			
		* only bring in surv if it's ami, chf, pnu, hip
		if (regexm("`cond'","^(ami|chf428|pnu|hip)$")) {
			local survvar = "surv_`cond'_eb"
		}
		else {
			local survvar = ""
		}
	
		* only bring in poc if it's ami, chf, or pnu
		if (regexm("`cond'","^(ami|chf428|pnu)$")) {
			local pocvar = "poc_`cond'_std"
		}
		else {
			local pocvar = ""
		}
		
		* we'll reload this file each time for bootstraps
		tempfile events_source
		save `events_source'

		* now create the bootstrap samples of events
		
		forvalues bsidx = 0/$NBOOT {

			* start with the quality measures for all open hospitals in the HRR
			* get them from, and process, the counts_allmeas file so it's appropriate for merging
			
			* create file of all hospital alternatives in that year
			tempfile joiner

			* just hospitals in $year
			* just hospitals that were in the overall sample in that year
			use ///
				pn_preboot year hrrnum_pn_preboot bootseq_within_hrrnum ///
				pn_boot hrrnum_pn_boot ///
				lat_pn lon_pn ///
				surv_`cond'_fe surv_`cond'_eb ///
				read_`cond'_fe read_`cond'_eb ///
				`pocvar' hcahps_std ///
				`usnspec'_ranked `usnspec'_eligible ///
				insamp_`cond'_tot ///
				if year==$YEAR & insamp_`cond'_tot==1 ///
				using counts_allmeas/bs_`sampsize'/bs`bsidx'.dta, clear
		
			drop year insamp_`cond'_tot
		
			* this better not fail
			isid pn_preboot bootseq_within_hrrnum
			isid pn_boot 
		
			* FIXME: if the hospital closes in the middle of the year, we keep it in the
			* choice set
		
			* note we've kept hospitals that were open but too small to get a risk-adjusted
			* survival and/or readmission

			save `joiner'

			* now load back in the source list of events
			use `events_source', clear
			
			* bring in the bootstrap weight
			merge m:1 hrrnum_pn using bootsample/bootsample`sampsize', assert(match) ///
				nogenerate keepusing(freq_bs`bsidx')
			
			* create freq_bs`bsidx' observations for each original observation
			drop if freq_bs`bsidx'==0
			expand freq_bs`bsidx'
			drop freq_bs`bsidx'
			
			* generate the bootstrap sequence
			egen bootseq_within_hrrnum = seq(), by(diag_id)
			
			* we'll use real hrrnum and bootseq to merge with the counts_allmeas file
			* that will give us the fake bootstrap pn and fake bootstrap hrrnum
			* move old diag ID, HRR ID and hospital ID out of the way
			rename diag_id diag_id_preboot
			rename pn pn_preboot
			rename hrrnum_pn hrrnum_pn_preboot

			* the new diag id is an interaction of original diag id and the bootstrap
			* sequence.
			egen diag_id_boot = group(diag_id_preboot bootseq_within_hrrnum)
			
			* now join to the hospital data to create a dataset with, for each patient, an
			* observation for all hospitals open in her HRR
	
			rename pn_preboot pn_preboot_chosen
			joinby hrrnum_pn_preboot bootseq_within_hrrnum using `joiner'
			
			* this better not fail
			isid diag_id_preboot bootseq_within_hrrnum pn_preboot
			isid diag_id_boot pn_boot
			
			* did the patient actually visit the hospital?
			gen byte chosen = pn_preboot==pn_preboot_chosen

			* drop the old id's
			drop diag_id_preboot pn_preboot bootseq_within_hrrnum hrrnum_pn_preboot pn_preboot_chosen
			
			* distance between bene and hosp
			gen double dist = acos( sin(lat_bene)*sin(lat_pn) + cos(lat_bene)*cos(lat_pn)*cos(lon_pn-lon_bene) )*3958.756
			* sometimes when they are in same zip the dist is blank... replace it to 0
			assert lat_bene==lat_pn & lon_bene==lon_pn if dist==.
			replace dist = 0 if dist==.
			gen double dist2 = dist^2
			
			drop lat_* lon_*
	
			* run the clogits on just the total subsample for hip/knee, and also on ed/nonedtr for
			* the other conditions
			if ("`cond'"=="hipkne") {
				local subsamples "tot"
			}
			else {
				local subsamples "tot ed nonedtr"
			}
	
			* measures in all conditions
			local measures "read usnews hcahps"
			* rhsvars for multivariate for all conditions
			local rhsmult "read_`cond'_eb hcahps_std"
			* sample for multivariate
			local sampmult "read_`cond'_eb!=. & hcahps_std!=."
	
			* all conditions except hip/knee get survival
			if ("`cond'"!="hipkne") {
				local measures "surv `measures'"
				local rhsmult "surv_`cond'_eb `rhsmult'"
				local sampmult "surv_`cond'_eb!=. & `sampmult'"
			}
	
			* all conditions except hip/knee and hip frac get poc
			if ("`cond'"!="hipkne" & "`cond'"!="hip") {
				local measures "`measures' poc"
				local rhsmult "`rhsmult' poc_`cond'_std"
				local sampmult "poc_`cond'_std!=. & `sampmult'"
			}
			
			* maybe this will speed things up a bit?
			sort diag_id_boot
	
			* univariate clogit
			foreach meas in `measures' {
	
				if ("`meas'"=="poc") {
					local rhs "poc_`cond'_std"
				}
				else if ("`meas'"=="surv"|"`meas'"=="read") {
					local rhs "`meas'_`cond'_eb"
				}
				else if ("`meas'"=="usnews") {
					local rhs "`usnspec'_ranked"
				}
				else if ("`meas'"=="hcahps") {
					local rhs "hcahps_std"
				}
			
				* restrict us news sample to eligible hospitals only for the us news
				* measure
				if ("`meas'"=="usnews") {
					local measrestriction "`usnspec'_eligible==1"
				}
				else {
					local measrestriction "1"
				}
			
				foreach pfx in `subsamples' {
		
					* code to add to if statement to restrict to ed/non-ed
					if ("`pfx'"=="tot") {
						local pfxrestriction "1"
					}
					else {
						local pfxrestriction "`pfx'==1"
					}
				
					* run the clogit (without clustering, since to use it in suest
					* we must estimate it with OIM VCE)
					
					* for bootstrap runs, initialize the model with parameter estimates
					* from the original run
					if (`bsidx'!=0) {
						estimates restore bs0_`meas'_`pfx'
						matrix b_init = e(b)
						local maximizeopts "iterate(1) from(b_init)"
					}
					else {
						local maximizeopts ""
					}

					clogit chosen dist dist2 `rhs' if `pfxrestriction' & `measrestriction', ///
						group(diag_id_boot) `maximizeopts'
				
					estimates store choicemodel_`meas'_`pfx'
					
					* for the original sample:
					* 1) save the estimates so that we can start bootstrap sample estimates
					* from original values
					* 2) pass through suest to get clustered VCE in case we're interested
					* in cluster-robust analytic standard errors. this should be
					* equivalent to just running it clustered in the first place
					
					if (`bsidx'==0) {
						estimates store bs0_`meas'_`pfx'
						suest choicemodel_`meas'_`pfx', vce(cl hrrnum_pn_boot)
						* now e() stores the suest model, the cluster robust
						* version of the model run before
					}
					* for the bootstrap samples, we'll just save OIM VCE's (because
					* we don't use them anyway)
			
					* mean, sd, median distance of chosen hospital
					qui summ dist if chosen & e(sample), detail
					estadd scalar meandist = r(mean)
					estadd scalar sddist = r(sd)
					estadd scalar mediandist = r(p50)
					* number of patients
					estadd scalar npatients = r(N)
					
					* share choosing closest hospital
					qui summ chose_closest if chosen & e(sample)
					estadd scalar shareclosest = r(mean)
					
					capture mkdir estimates/clogit/`cond'`sampsize'_`meas'_`pfx'
					estimates save estimates/clogit/`cond'`sampsize'_`meas'_`pfx'/bs`bsidx'.ster, replace
		
				}
			
				if ("`cond'" != "hipkne") {
				
					* bring together ed and noned samples to test difference in MRS
					
					* cluster properly for the original run in case we want analytic se,
					* otherwise use heterosked VCE which is slightly faster
					if (`bsidx'==0) {
						local vce "vce(cl hrrnum_pn_boot)"
					}
					else {
						local vce ""
					}
				
					suest choicemodel_`meas'_ed choicemodel_`meas'_nonedtr, `vce'
					capture mkdir estimates/clogit/`cond'`sampsize'_`meas'_sur
					estimates save estimates/clogit/`cond'`sampsize'_`meas'_sur/bs`bsidx'.ster, replace
					estimates drop choicemodel_`meas'_ed choicemodel_`meas'_nonedtr
				
				}
			
				estimates drop choicemodel_`meas'_tot
			
			}
		
			* multivariate clogit

			* for bootstrap runs, initialize the model with parameter estimates
			* from the original run
			if (`bsidx'!=0) {
				estimates restore bs0_mult
				matrix b_init = e(b)
				local maximizeopts "iterate(1) from(b_init)"
			}
			else {
				local maximizeopts ""
			}			

			* cluster properly for the original run in case we want analytic se,
			* otherwise use heterosked VCE which is slightly faster
			if (`bsidx'==0) {
				local vce "vce(cl hrrnum_pn_boot)"
			}
			else {
				local vce ""
			}
			
			clogit chosen dist dist2 `rhsmult' if `sampmult', ///
				group(diag_id_boot) `vce' `maximizeopts'

			* save the original sample estimates so that we can start bootstrap
			* sample estimates from original values
			if (`bsidx'==0) {
				estimates store bs0_mult
			}
	
			* mean, sd, median distance of chosen hospital
			qui summ dist if chosen & e(sample), detail
			estadd scalar meandist = r(mean)
			estadd scalar sddist = r(sd)
			estadd scalar mediandist = r(p50)
			* number of patients
			estadd scalar npatients = r(N)
	
			* share choosing closest hospital
			qui summ chose_closest if chosen & e(sample)
			estadd scalar shareclosest = r(mean)
	
			capture mkdir estimates/clogit/`cond'`sampsize'_mult
			estimates save estimates/clogit/`cond'`sampsize'_mult/bs`bsidx'.ster, replace

		}
		
		* get rid of the *_bs0 (original run) estimates that were used to initialize
		* the bootstrap run clogits
		estimates drop _all
		
		
	}

}

* univariate logit
matrix clog_uni = J(22,5,.)
matrix colnames clog_uni = ami chf428 pn hip hipkne
matrix rownames clog_uni = meanmilesmrs sdmiles blank mrssurv se pats blank mrsread se pats blank mrsusnews se pats blank mrspoc se pats blank mrshcahps se pats

* multivariate logit
matrix clog_mult = J(13,5,.)
matrix colnames clog_mult = ami chf428 pn hip hipkne
matrix rownames clog_mult = meanmilesmrs sdmiles blank mrssurv se mrsread se mrspoc se mrshcahps se blank pats

* logit by ed
matrix clog_ed = J(32,11,.)
matrix colnames clog_ed = ami_ed ami_noned blank chf428_ed chf428_noned blank pn_ed pn_noned blank hip_ed hip_noned
matrix rownames clog_ed = ///
	sharepats mediandist meandist sddist sharenear blank ///
	mrssurv se pval pats blank ///
	mrsread se pval pats blank ///
	mrsusnews se pval pats blank ///
	mrspoc se pval pats blank ///
	mrshcahps se pval pats blank ///
	meansformrs

* "expanded" conditional logit table
matrix clog_exp = J(20,27,.)
matrix colnames clog_exp = ///
	ami ami ami ami ami ami ///
	chf428 chf428 chf428 chf428 chf428 chf428 ///
	pn pn pn pn pn pn ///
	hip hip hip hip hip ///
	hipkne hipkne hipkne hipkne
matrix rownames clog_exp = ///
	meanmiles sdmiles ///
	blank dist se dist2 se ras se rar se usnews se pocz se hcahps se ///
	pats obs obspats

* expanded table for ed/noned split
matrix clog_exped = J(20,38,.)
matrix colnames clog_exped = ///
	ami_ed ami_noned ami_ed ami_noned ami_ed ami_noned ami_ed ami_noned ami_ed ami_noned ///
	chf428_ed chf428_noned chf428_ed chf428_noned chf428_ed chf428_noned chf428_ed chf428_noned chf428_ed chf428_noned ///
	pn_ed pn_noned pn_ed pn_noned pn_ed pn_noned pn_ed pn_noned pn_ed pn_noned ///
	hip_ed hip_noned hip_ed hip_noned hip_ed hip_noned hip_ed hip_noned
matrix rownames clog_exped = ///
	meanmiles sdmiles ///
	blank dist se dist2 se ras se rar se usnews se pocz se hcahps se ///
	pats obs obspats

local c_uni = 1
local c_mult = 1
local c_ed = 1
local c_exp = 1
local c_exped = 1

foreach cond in $CONDITIONS {

	* set us news specialty
	if ("`cond'"=="ami" | "`cond'"=="chf428") {
		local usnspec = "heart"
	}
	else if ("`cond'"=="pnu") {
		local usnspec = "resp"
	}
	else if ("`cond'"=="hip" | "`cond'"=="hipkne") {
		local usnspec = "ortho"
	}
	else {
		local usnspec = ""
	}
	
	if ("`cond'"=="ami"|"`cond'"=="chf428"|"`cond'"=="pnu") {
		local measures "surv read usnews poc hcahps"
		local measures_mult "surv read poc hcahps"
	}
	else if ("`cond'"=="hip") {
		local measures "surv read usnews hcahps"
		local measures_mult "surv read hcahps"
	}
	else if ("`cond'"=="hipkne") {
		local measures "read usnews hcahps"
		local measures_mult "read hcahps"
	}
	
	* pull in the mean distance used for evaluating the MRS
	* for hip/knee from readmission reg
	* for all else, from survival reg
	if ("`cond'"=="hipkne") {
		estimates use estimates/clogit/`cond'`sampsize'_read_tot/bs0.ster
	}
	else {
		estimates use estimates/clogit/`cond'`sampsize'_surv_tot/bs0.ster
	}
	
	local meandist = e(meandist)
	local sddist = e(sddist)
	
	* mean mrs was evaluated at, sd of miles for that spec too
	matrix clog_uni[1,`c_uni'] = `meandist' \ `sddist'
	matrix clog_mult[1,`c_uni'] = `meandist' \ `sddist'

	* for conditions that we analyze by ed, add to table:
	* share of patients
	* mean miles to hospital
	* share at nearest hospital
	if ("`cond'"!="hipkne") {
		local npatients = e(npatients)

		estimates use estimates/clogit/`cond'`sampsize'_surv_ed/bs0.ster
		local ned = e(npatients)
		local mediandisted = e(mediandist)
		local meandisted = e(meandist)
		local sddisted = e(sddist)
		local shareclosested = e(shareclosest)

		estimates use estimates/clogit/`cond'`sampsize'_surv_nonedtr/bs0.ster
		local nnoned = e(npatients)
		local mediandistnoned = e(mediandist)
		local meandistnoned = e(meandist)
		local sddistnoned = e(sddist)
		local shareclosestnoned = e(shareclosest)
		
		* assert no longer true! since non-ed is the transfer subsample
		* assert `npatients'==`ned'+`nnoned'
		
		matrix clog_ed[1,`c_ed'] = ///
			(`ned'/`npatients') , (`nnoned'/`npatients') \ ///
			`mediandisted' , `mediandistnoned' \ ///
			`meandisted' , `meandistnoned' \ ///
			`sddisted' , `sddistnoned' \ ///
			`shareclosested' , `shareclosestnoned'
		
		matrix clog_ed[32,`c_ed'] = `meandist', `meandist'
	}

	
	* iterate over the measures and fill in the univariate table
	* and the univariate columns of the multivariate table
	foreach meas in `measures' {
	
		if ("`meas'"=="surv") {
			* right-hand side variable name
			local rhs "surv_`cond'_eb"
			* offset for putting the MRS in the univariate table
			local r_uni = 4
			* offset for putting the coefficient on the expanded table
			local r_exp = 8
			* offset for putting the MRS in the ED table
			local r_ed = 7
			* offset for putting the MRS in the expanded ED table
			local r_exped = 8
			* multiplier in the denominator for calculating mrs
			local mrsmult = 100
		}
		else if ("`meas'"=="read") {
			local rhs "read_`cond'_eb"
			local r_uni = 8
			local r_exp = 10
			local r_ed = 12
			local r_exped = 10
			local mrsmult = 100
		}
		else if ("`meas'"=="usnews") {
			local rhs "`usnspec'_ranked"
			local r_uni = 12
			local r_exp = 12
			local r_ed = 17
			local r_exped = 12
			local mrsmult = 1
		}
		else if ("`meas'"=="poc") {
			local rhs "poc_`cond'_std"
			local r_uni = 16
			local r_exp = 14
			local r_ed = 22
			local r_exped = 14
			local mrsmult = 1
		}
		else if ("`meas'"=="hcahps") {
			local rhs "hcahps_std"
			local r_uni = 20
			local r_exp = 16
			local r_ed = 27
			local r_exped = 16
			local mrsmult = 1
		}
		
		if ("`cond'"=="hipkne") {
			local pfxlist = "tot"
		}
		else {
			local pfxlist = "tot ed nonedtr"
		}
		
		foreach pfx in `pfxlist' {
			
			if ("`pfx'"=="tot") {
				local mat_uni = "clog_uni"
				local mat_exp = "clog_exp"
				local r_pfx_uni = `r_uni'
				local c_pfx_uni = `c_uni'
				local r_pfx_exp = `r_exp'
				local c_pfx_exp = `c_exp'
			}
			else {
				local mat_uni = "clog_ed"
				local mat_exp = "clog_exped"
				local r_pfx_uni = `r_ed'
				local c_pfx_uni = `c_ed'
				local r_pfx_exp = `r_exped'
				local c_pfx_exp = `c_exped'
			}

		
			* first: statistics taken from original run of the model
			estimates use estimates/clogit/`cond'`sampsize'_`meas'_`pfx'/bs0.ster

			* add mean & sd distance to the expanded table
			matrix `mat_exp'[1,`c_pfx_exp'] = e(meandist) \ e(sddist)

			* add reg size stats to expanded table
			matrix `mat_exp'[18,`c_pfx_exp'] = e(npatients) \ e(N) \ (e(N)/e(npatients))

			* add npatients to univariate baseline table
			* and to ed/non-ed table
			if ("`pfx'"=="tot") {
				matrix `mat_uni'[`r_pfx_uni'+2,`c_pfx_uni'] = e(npatients)
			}
			else {
				matrix `mat_uni'[`r_pfx_uni'+3,`c_pfx_uni'] = e(npatients)
			}
		
			* second: statistics involving bootstrapped standard errors

			eboot using estimates/clogit/`cond'`sampsize'_`meas'_`pfx', ///
				nboot($NBOOT) `stderror'

			* add distance coeffs to expanded table
			matrix `mat_exp'[4,`c_pfx_exp'] = _b[dist] \ -_se[dist] \ _b[dist2] \ -_se[dist2]
		
			* add rhs var coefficient to expanded table
			matrix `mat_exp'[`r_pfx_exp',`c_pfx_exp'] = _b[`rhs']
			matrix `mat_exp'[`r_pfx_exp'+1,`c_pfx_exp'] = -_se[`rhs']
			
			* calculate MRS
			nlcom _b[`rhs']/(`mrsmult'*( _b[dist] + 2*_b[dist2]*`meandist' ))
		
			* add MRS to univariate table
			matrix b = r(b)
			matrix V = r(V)
			matrix `mat_uni'[`r_pfx_uni',`c_pfx_uni'] = b[1,1] \ (-sqrt( V[1,1] ))
									
			* add test for equality of MRS between ed and non-ed to the ed table
			if ("`pfx'"=="nonedtr") {
				* pull in the SUR
				eboot using estimates/clogit/`cond'`sampsize'_`meas'_sur, ///
					nboot($NBOOT) `stderror'
				
				* first equation
				local left = substr("choicemodel_`meas'_ed_chosen",1,32)
				* second equation
				local right = substr("choicemodel_`meas'_nonedtr_chosen",1,32)
				
				* do the test
				testnl [`left']`rhs'/(`mrsmult'*( [`left']dist + 2*[`left']dist2*`meandist' )) = [`right']`rhs'/(`mrsmult'*( [`right']dist + 2*[`right']dist2*`meandist' ))
				matrix `mat_uni'[`r_pfx_uni'+2,`c_pfx_uni'] = r(p)
			}
			
			if ("`pfx'"=="tot") {
				local c_exp = `c_exp' + 1
			}
			else {
				local c_exped = `c_exped' + 1
			}
			
			if ("`pfx'"=="ed") {
				local c_ed = `c_ed' + 1
			}
			else if ("`pfx'"=="nonedtr") {
				local c_ed = `c_ed' - 1
			}
		}
	}
	
	* fill in the multivariate table and the multivariate column of the expanded table
	
	* first: stats about the sample pulled from the original run
	estimates use estimates/clogit/`cond'`sampsize'_mult/bs0.ster

	* add mean & sd distance to the expanded table
	matrix clog_exp[1,`c_exp'] = e(meandist) \ e(sddist)

	* add regression stats to multivariate table and expanded table
	matrix clog_mult[13,`c_mult'] = e(npatients)
	matrix clog_exp[18,`c_exp'] = e(npatients) \ e(N) \ (e(N)/e(npatients))
	
	* second: stats involving bootstrapped standard errors
	eboot using estimates/clogit/`cond'`sampsize'_mult, nboot($NBOOT) `stderror'
	
	* add distance coeffs to expanded table
	matrix clog_exp[4,`c_exp'] = _b[dist] \ -_se[dist] \ _b[dist2] \ -_se[dist2]
		
	foreach meas in `measures_mult' {
		
		if ("`meas'"=="surv") {
			local rhs "surv_`cond'_eb"
			* offset for putting the MRS in the multivariate table
			local r_mult = 4
			* offset for putting the coefficient on the expanded table
			local r_exp = 8
			* multiplier in the denominator for calculating mrs
			local mrsmult = 100
		}
		else if ("`meas'"=="read") {
			local rhs "read_`cond'_eb"
			local r_mult = 6
			local r_exp = 10
			local mrsmult = 100
		}
		else if ("`meas'"=="poc") {
			local rhs "poc_`cond'_std"
			local r_mult = 8
			local r_exp = 14
			local mrsmult = 1
		}
		else if ("`meas'"=="hcahps") {
			local rhs "hcahps_std"
			local r_mult = 10
			local r_exp = 16
			local mrsmult = 1
		}
		
		* add coefficient to expanded table
		matrix clog_exp[`r_exp',`c_exp'] = _b[`rhs'] \ -_se[`rhs']
		
		* calculate MRS and add it to the multivariate table
		nlcom _b[`rhs']/(`mrsmult'*( _b[dist] + 2*_b[dist2]*`meandist' ))
		matrix b = r(b)
		matrix V = r(V)
		matrix clog_mult[`r_mult',`c_mult'] = b[1,1] \ (-sqrt( V[1,1] ))
		
	}
	
	local c_uni = `c_uni' + 1
	local c_mult = `c_mult' + 1
	local c_exp = `c_exp' + 1
	local c_ed = `c_ed' + 3

}

putexcel A1=matrix(clog_exp, names) using `resultsdir'/clogit_exp`sampsize'.xlsx, replace
putexcel A1=matrix(clog_exped, names) using `resultsdir'/clogit_exped`sampsize'.xlsx, replace
putexcel A1=matrix(clog_ed, names) using `resultsdir'/clogit_ed`sampsize'.xlsx, replace
putexcel A1=matrix(clog_uni, names) using `resultsdir'/clogit_uni`sampsize'.xlsx, replace
putexcel A1=matrix(clog_mult, names) using `resultsdir'/clogit_mult`sampsize'.xlsx, replace

log close
