* static and dynamic allocation results

set more off
capture log close
clear

set matsize 1000

log using logs/alloc.log, replace

* set to 0001 or 05 or 20 or 100 to choose sample to work from
local sampsize = "100"

* what is the base year for static/dynamic allocation
local baseyear = 2008

* results dir
local resultsdir = "results/tabledata"

* which conditions?
global CONDITIONS "ami chf428 pnu hip hipkne"

* which conditions when splitting by ED?
global CONDITIONS_ED "ami chf428 pnu hip"

* bootstrap count
global NBOOT = 300

* use analytic or bootstrapped standard errors
global ANALYTIC = 0

adopath ++ PLUS
adopath ++ ./ado/

if ($ANALYTIC) {
	local stderror "analytic"
}
else {
	local stderror ""
}


forvalues bsidx=0/$NBOOT {

	use counts_allmeas/bs_`sampsize'/bs`bsidx'.dta, clear
	
	keep if year==`baseyear'
	
	xtset hrrnum_pn_boot
	
	* univariate allocation
	* run it with the full sample for each measure and with the subset of hospitals that
	* reported all measures (except US news)

	foreach constsamp in fullsamp constsamp {
		foreach alloc in static dyn {
			display "****** `alloc' results *******"

			foreach cond in $CONDITIONS {
				display "***** WORKING ON `cond' *****"
	
				if ("`alloc'"=="static") {
					local lhs = "lnpatients_`cond'_tot"
				}
				else {
					local lhs = "growth_`cond'_tot"
				}
				
				local regsamp = "insamp_`cond'_tot"
			
				* further limit the sample for the 'constsamp' spec
				if ("`constsamp'"=="constsamp") {
					local extrasamp = "& read_`cond'_eb!=. & hcahps_std!=."
				
					* further limit to hospitals with process of care, if available
					if (regexm("`cond'","^(ami|chf428|pnu)$")) {
						local extrasamp "`extrasamp' & poc_`cond'_std!=."
					}
				
					* further limit to hospitals with a survival, if available
					if (regexm("`cond'","^(ami|chf428|pnu|hip)$")) {
						local extrasamp "`extrasamp' & surv_`cond'_eb!=."
					}
				}
				else {
					local extrasamp = ""
				}
		
				* survival
				if (regexm("`cond'","^(ami|chf428|pnu|hip)$")) {
					xtreg `lhs' surv_`cond'_eb if `regsamp' `extrasamp', ///
						fe vce(cluster hrrnum_pn_boot)
					capture mkdir estimates/alloc_uni/`constsamp'/`cond'`sampsize'_surv_`alloc'
					estimates save estimates/alloc_uni/`constsamp'/`cond'`sampsize'_surv_`alloc'/bs`bsidx'.ster, replace
				}
		
				* readmission
				xtreg `lhs' read_`cond'_eb if `regsamp' `extrasamp', ///
					fe vce(cluster hrrnum_pn_boot)
				capture mkdir estimates/alloc_uni/`constsamp'/`cond'`sampsize'_read_`alloc'
				estimates save estimates/alloc_uni/`constsamp'/`cond'`sampsize'_read_`alloc'/bs`bsidx'.ster, replace
				
				* us news
				if ("`constsamp'"=="fullsamp") {
					if ("`cond'"=="ami" | "`cond'"=="chf428") {
						local usnspec = "heart"
					}
					else if ("`cond'"=="pnu") {
						local usnspec = "resp"
					}
					else if ("`cond'"=="hip" | "`cond'"=="hipkne") {
						local usnspec = "ortho"
					}
					else {
						local usnspec = ""
					}

					xtreg `lhs' `usnspec'_ranked if `regsamp' & `usnspec'_eligible==1, ///
						fe vce(cluster hrrnum_pn_boot)
					capture mkdir estimates/alloc_uni/`constsamp'/`cond'`sampsize'_usnews_`alloc'
					estimates save estimates/alloc_uni/`constsamp'/`cond'`sampsize'_usnews_`alloc'/bs`bsidx'.ster, replace
				}

				* process of care
				if (regexm("`cond'","^(ami|chf428|pnu)$")) {
					xtreg `lhs' poc_`cond'_std if `regsamp' `extrasamp', ///
						fe vce(cluster hrrnum_pn_boot)
					capture mkdir estimates/alloc_uni/`constsamp'/`cond'`sampsize'_poc_`alloc'
					estimates save estimates/alloc_uni/`constsamp'/`cond'`sampsize'_poc_`alloc'/bs`bsidx'.ster, replace
				}
		
				* hcahps
				xtreg `lhs' hcahps_std if `regsamp' `extrasamp', ///
					fe vce(cluster hrrnum_pn_boot)
				capture mkdir estimates/alloc_uni/`constsamp'/`cond'`sampsize'_hcahps_`alloc'
				estimates save estimates/alloc_uni/`constsamp'/`cond'`sampsize'_hcahps_`alloc'/bs`bsidx'.ster, replace
			}
		}
	}

	* multivariate allocation
	foreach alloc in static dyn {
		display "****** `alloc' results *******"

		foreach cond in $CONDITIONS {
			display "***** WORKING ON `cond' *****"
	
			if ("`alloc'"=="static") {
				local lhs = "lnpatients_`cond'_tot"
			}
			else {
				local lhs = "growth_`cond'_tot"
			}

			local regsamp = "insamp_`cond'_tot"
		
			* RHS variables in multivariate regression
			
			if (regexm("`cond'","^(ami|chf428|pnu)$")) {
				local rhs "surv_read_`cond'_eb2 read_surv_`cond'_eb2 poc_`cond'_std hcahps_std"
			}
			else if ("`cond'"=="hip") {
				local rhs "surv_read_`cond'_eb2 read_surv_`cond'_eb2 hcahps_std"
			}
			else if ("`cond'"=="hipkne") {
				* we use ebayes1 for hip/knee readm, but it's adjusted "within" hcahps
				local rhs "read_`cond'_eb_m hcahps_std"
			}
			
			* multivariate allocation regression
			xtreg `lhs' `rhs' if `regsamp', fe vce(cluster hrrnum_pn_boot)
			capture mkdir estimates/alloc_multi/`cond'`sampsize'_`alloc'
			estimates save estimates/alloc_multi/`cond'`sampsize'_`alloc'/bs`bsidx'.ster, replace
		}
	}

	* sensitivity to EB adjustment and risk adjustment

	foreach alloc in static dyn {
		display "****** `alloc' results *******"

		foreach cond in $CONDITIONS {
			display "***** WORKING ON `cond' *****"

			if ("`alloc'"=="static") {
				local lhs = "lnpatients_`cond'_tot"
			}
			else {
				local lhs = "growth_`cond'_tot"
			}
			
			local regsamp = "insamp_`cond'_tot"
			
			local allspec "read_fe rars_eb rnra_eb"
			if (regexm("`cond'","^(ami|chf428|pnu|hip)$")) {
				* only run survival sensitivity on non-hip/knee
				local allspec "`allspec' surv_fe sars_eb snra_eb"
			}
			
			foreach spec in `allspec' {
			
				* change e.g. surv_fe -> surv_ami_fe
				local rhs = regexr("`spec'","_","_`cond'_")
	
				xtreg `lhs' `rhs' if `regsamp', fe vce(cluster hrrnum_pn_boot)
				capture mkdir estimates/alloc_sens/`cond'`sampsize'_`spec'_`alloc'
				estimates save estimates/alloc_sens/`cond'`sampsize'_`spec'_`alloc'/bs`bsidx'.ster, replace

			}
		}
	}
	
	* productivity allocation for ami
	foreach alloc in static dyn {
	
		local cond ""
	
		if ("`alloc'"=="static") {
			local lhs = "lnpatients_ami_tot"
			
		}
		else {
			local lhs = "growth_ami_tot"
		}
		
		local regsamp = "insamp_ami_tot"
		
		* allocation wrt productivity (spending)
		xtreg `lhs' prsp_ami_eb if `regsamp', ///
			fe vce(cluster hrrnum_pn_boot)
		capture mkdir estimates/alloc_prod/ami`sampsize'_prsp_`alloc'
		estimates save estimates/alloc_prod/ami`sampsize'_prsp_`alloc'/bs`bsidx'.ster, replace

		* allocation wrt productivity (real resources)
		xtreg `lhs' prre_ami_eb if `regsamp', ///
			fe vce(cluster hrrnum_pn_boot)
		capture mkdir estimates/alloc_prod/ami`sampsize'_prre_`alloc'
		estimates save estimates/alloc_prod/ami`sampsize'_prre_`alloc'/bs`bsidx'.ster, replace
		
		* allocation wrt survival and spending
		xtreg `lhs' surv_spnd_ami_eb2 spnd_surv_ami_eb2 if `regsamp', ///
			fe vce(cluster hrrnum_pn_boot)
		capture mkdir estimates/alloc_prod/ami`sampsize'_spnd_`alloc'
		estimates save estimates/alloc_prod/ami`sampsize'_spnd_`alloc'/bs`bsidx'.ster, replace
	
		* allocation wrt survival and resources
		xtreg `lhs' surv_drgw_ami_eb2 drgw_surv_ami_eb2 if `regsamp', ///
			fe vce(cluster hrrnum_pn_boot)
		capture mkdir estimates/alloc_prod/ami`sampsize'_drgw_`alloc'
		estimates save estimates/alloc_prod/ami`sampsize'_drgw_`alloc'/bs`bsidx'.ster, replace
		
		* allocation wrt spending (unconditional)
		xtreg `lhs' spnd_ami_eb if `regsamp', ///
			fe vce(cluster hrrnum_pn_boot)
		capture mkdir estimates/alloc_prod/ami`sampsize'_spnd_uncond_`alloc'
		estimates save estimates/alloc_prod/ami`sampsize'_spnd_uncond_`alloc'/bs`bsidx'.ster, replace

		* allocation wrt spending (real resources)
		xtreg `lhs' drgw_ami_eb if `regsamp', ///
			fe vce(cluster hrrnum_pn_boot)
		capture mkdir estimates/alloc_prod/ami`sampsize'_drgw_uncond_`alloc'
		estimates save estimates/alloc_prod/ami`sampsize'_drgw_uncond_`alloc'/bs`bsidx'.ster, replace
	}	
	
	* mechanical allocation
	foreach alloc in static dyn {
		display "****** `alloc' results *******"

		foreach cond in $CONDITIONS {
			display "***** WORKING ON `cond' *****"
		
		
			if ("`alloc'"=="static") {
				local lhs = "lnclosest_`cond'"
			}
			else {
				local lhs = "gclosest_`cond'"
			}
			
			local regsamp = "insamp_closest_`cond'"
			
			* survival
			if (regexm("`cond'","^(ami|chf428|pnu|hip)$")) {
				xtreg `lhs' surv_`cond'_eb if `regsamp', ///
					fe vce(cluster hrrnum_pn_boot)
				capture mkdir estimates/alloc_mech/`cond'`sampsize'_surv_`alloc'
				estimates save estimates/alloc_mech/`cond'`sampsize'_surv_`alloc'/bs`bsidx'.ster, replace
			}
		
			* readmission
			xtreg `lhs' read_`cond'_eb if `regsamp', ///
				fe vce(cluster hrrnum_pn_boot)
			capture mkdir estimates/alloc_mech/`cond'`sampsize'_read_`alloc'
			estimates save estimates/alloc_mech/`cond'`sampsize'_read_`alloc'/bs`bsidx'.ster, replace
		
			* us news
		
			if ("`cond'"=="ami" | "`cond'"=="chf428") {
				local usnspec = "heart"
			}
			else if ("`cond'"=="pnu") {
				local usnspec = "resp"
			}
			else if ("`cond'"=="hip" | "`cond'"=="hipkne") {
				local usnspec = "ortho"
			}
			else {
				local usnspec = ""
			}

			* note must further restrict regression to eligble hospitals
			xtreg `lhs' `usnspec'_ranked if `regsamp' & `usnspec'_eligible==1, ///
				fe vce(cluster hrrnum_pn_boot)
			capture mkdir estimates/alloc_mech/`cond'`sampsize'_usnews_`alloc'
			estimates save estimates/alloc_mech/`cond'`sampsize'_usnews_`alloc'/bs`bsidx'.ster, replace

			* process ofcare
			if (regexm("`cond'","^(ami|chf428|pnu)$")) {
				xtreg `lhs' poc_`cond'_std if `regsamp', ///
					fe vce(cluster hrrnum_pn_boot)
				capture mkdir estimates/alloc_mech/`cond'`sampsize'_poc_`alloc'
				estimates save estimates/alloc_mech/`cond'`sampsize'_poc_`alloc'/bs`bsidx'.ster, replace
			}
		
			* hcahps
			xtreg `lhs' hcahps_std if `regsamp', fe vce(cluster hrrnum_pn_boot)
			capture mkdir estimates/alloc_mech/`cond'`sampsize'_hcahps_`alloc'
			estimates save estimates/alloc_mech/`cond'`sampsize'_hcahps_`alloc'/bs`bsidx'.ster, replace
		}
	}
		
	* allocation results split by ed/non-ed (and non-ed non-transfer too)
	
	* 3 approaches
	* 1) regression - full sample (hosp with >= 1 patients in category)
	* 2) regression - const sample (hosp with >= 1 patients in ED AND non-ED)
	* 3) poisson - full sample (hosp with >= 1 patients overall)
	
	foreach approach in fullsamp constsamp poisson {

		if ("`approach'"=="poisson") {
			* only run poisson for static allocation
			local alloclist "static"
			
			* use poisson regression commands and cluster robust vce (called robust here)
			local xtcmd "xtpoisson"
			local xtvce "robust"
			local regcmd "poisson"
		}
		else {
			local alloclist "static dyn"
			
			* use linear regression commands and cluster robust vce
			local xtcmd "xtreg"
			local xtvce "cluster hrrnum_pn_boot"
			local regcmd "regress"
		}
		
		foreach alloc in `alloclist' {
	
			if ("`alloc'"=="static" & "`approach'" != "poisson") {
				local lhs_prefix = "lnpatients"
			}
			else if ("`alloc'"=="static" & "`approach'" == "poisson") {
				local lhs_prefix = "npatients"
			}
			else {
				local lhs_prefix = "growth"
			}

			foreach cond in $CONDITIONS_ED {
		
				local measures "read usnews hcahps"

				if (regexm("`cond'","^(ami|chf428|pnu|hip)$")) {
					local measures "surv `measures'"
				}

		
				if (regexm("`cond'","^(ami|chf428|pnu)$")) {
					local measures "poc `measures'"
				}
		
				foreach meas in `measures' {
		
					if ("`meas'"=="surv") {
						local rhs = "surv_`cond'_eb"
						local extrasamp = ""
					}
					else if ("`meas'"=="read") {
						local rhs = "read_`cond'_eb"
						local extrasamp = ""
					}
					else if ("`meas'"=="usnews") {
						if ("`cond'"=="ami" | "`cond'"=="chf428") {
							local usnspec = "heart"
						}
						else if ("`cond'"=="pnu") {
							local usnspec = "resp"
						}
						else if ("`cond'"=="hip" | "`cond'"=="hipkne") {
							local usnspec = "ortho"
						}
						else {
							local usnspec = ""
						}
				
						local rhs = "`usnspec'_ranked"
						local extrasamp = "& `usnspec'_eligible==1"
					}
					else if ("`meas'"=="poc") {
						local rhs = "poc_`cond'_std"
						local extrasamp = ""
					}
					else if ("`meas'"=="hcahps") {
						local rhs = "hcahps_std"
						local extrasamp = ""
					}
					
					foreach pfx in ed nonedtr nonednontr {
						if ("`approach'"=="constsamp") {
							local regsamp = "insamp_`cond'_ed & insamp_`cond'_nonedtr"
							//local regsamp "insamp_`cond'_tot & `lhs_prefix'_`cond'_ed!=. & `lhs_prefix'_`cond'_nonedtr!=."
						}
						else if ("`approach'"=="poisson") {
							local regsamp = "insamp_`cond'_tot"
						}
						else {
							local regsamp = "insamp_`cond'_`pfx'"
						}

						local lhs = "`lhs_prefix'_`cond'_`pfx'"

						`xtcmd' `lhs' `rhs' if `regsamp' `extrasamp', fe vce(`xtvce')
						capture mkdir estimates/alloc_ednew/`approach'/`cond'`sampsize'_`meas'_`pfx'_`alloc'
						estimates save estimates/alloc_ednew/`approach'/`cond'`sampsize'_`meas'_`pfx'_`alloc'/bs`bsidx'.ster, replace

						local xtcoef = _b[`rhs']

						* for storing and estimating p value of diff between
						* ed and nonedtrans sample, have to use regress because xtreg doesn't
						* generate a score for suest to use
						qui `regcmd' `lhs' `rhs' i.hrrnum_pn_boot if `regsamp' `extrasamp'
						* better have the same coeff as before
						assert abs(_b[`rhs'] - `xtcoef') < .0001
						estimates store `pfx'
				
					}
			
					* test whether static coef was equal between ed and nonedtrans samples
					qui suest ed nonedtr, vce(cl hrrnum_pn_boot)
					capture mkdir estimates/alloc_ednew/`approach'/`cond'`sampsize'_`meas'_sur_`alloc'
					estimates save estimates/alloc_ednew/`approach'/`cond'`sampsize'_`meas'_sur_`alloc'/bs`bsidx'.ster, replace

					estimates drop ed nonedtr
			
				}
		
			}

		}
	}
	
	* static allocation sensitivity to truncation
	* static allocation on choice model subsample
	* static allocation - poisson approach

	* lower limit for truncation
	local ll = ln(25)

	foreach cond in $CONDITIONS {
	
		* choice model subsample
		gen lnpatients_`cond'_hrr = ln(npatients_`cond'_hrr)

		local measures "read usnews hcahps"

		if (regexm("`cond'","^(ami|chf428|pnu|hip)$")) {
			local measures "surv `measures'"
		}


		if (regexm("`cond'","^(ami|chf428|pnu)$")) {
			local measures "poc `measures'"
		}

		foreach meas in `measures' {

			if ("`meas'"=="surv") {
				local rhs = "surv_`cond'_eb"
				local extrasamp = ""
			}
			else if ("`meas'"=="read") {
				local rhs = "read_`cond'_eb"
				local extrasamp = ""
			}
			else if ("`meas'"=="usnews") {
				if ("`cond'"=="ami" | "`cond'"=="chf428") {
					local usnspec = "heart"
				}
				else if ("`cond'"=="pnu") {
					local usnspec = "resp"
				}
				else if ("`cond'"=="hip" | "`cond'"=="hipkne") {
					local usnspec = "ortho"
				}
				else {
					local usnspec = ""
				}
		
				local rhs = "`usnspec'_ranked"
				local extrasamp = "& `usnspec'_eligible==1"
			}
			else if ("`meas'"=="poc") {
				local rhs = "poc_`cond'_std"
				local extrasamp = ""
			}
			else if ("`meas'"=="hcahps") {
				local rhs = "hcahps_std"
				local extrasamp = ""
			}
			
			* choice model subsample
			xtreg lnpatients_`cond'_hrr `rhs' ///
				if insamp_`cond'_tot `extrasamp', ///
				fe vce(cluster hrrnum_pn_boot)
			
			* add some stats about patients to the readmission measure bootstrap 0
			if ("`meas'"=="read" & `bsidx'==0) {
				* patients in hrr
				qui summ npatients_`cond'_hrr if insamp_`cond'_tot
				estadd scalar npatients_hrr = r(sum)
				* patients total
				qui summ npatients_`cond'_tot if insamp_`cond'_tot
				estadd scalar npatients_tot = r(sum)
			}
			
			capture mkdir estimates/alloc_samehrr/`cond'`sampsize'_`meas'_static
			estimates save estimates/alloc_samehrr/`cond'`sampsize'_`meas'_static/bs`bsidx'.ster, replace
			
			* static allocation with truncation
			xtreg lnpatients_`cond'_tot `rhs' ///
				if insamp_`cond'_tot `extrasamp' & lnpatients_`cond'_tot >= `ll', ///
				fe vce(cluster hrrnum_pn_boot)
			capture mkdir estimates/alloc_trunc/`cond'`sampsize'_`meas'_xtreg_static
			estimates save estimates/alloc_trunc/`cond'`sampsize'_`meas'_xtreg_static/bs`bsidx'.ster, replace
			
			local N = e(N)
			
			* truncated regression
			truncreg lnpatients_`cond'_tot `rhs' i.hrrnum_pn_boot ///
				if insamp_`cond'_tot `extrasamp', ///
				ll(`ll') vce(cluster hrrnum_pn_boot)
			capture mkdir estimates/alloc_trunc/`cond'`sampsize'_`meas'_truncreg_static
			estimates save estimates/alloc_trunc/`cond'`sampsize'_`meas'_truncreg_static/bs`bsidx'.ster, replace
			
			* samples ought to be the same
			assert e(N)==`N'
						
			* poisson approach to static allocation
			xtpoisson npatients_`cond'_tot `rhs' ///
				if insamp_`cond'_tot `extrasamp', ///
				fe vce(robust)
			capture mkdir estimates/alloc_poisson/`cond'`sampsize'_`meas'_static
			estimates save estimates/alloc_poisson/`cond'`sampsize'_`meas'_static/bs`bsidx'.ster, replace
									
		}
		
		drop lnpatients_`cond'_hrr

	}
	
}

********** write out results **********

* bring in base data for calculating some stats
use counts_allmeas/bs_`sampsize'/bs0.dta, clear
keep if year==`baseyear'

matrix alloc_poi = J(19,14,.)
matrix colnames alloc_poi = ami_baseline ami_poi blank chf428_baseline chf428_poi blank pnu_baseline pnu_poi blank hip_baseline hip_poi blank hipkne_baseline hipkne_poi
matrix rownames alloc_poi = surv se N blank read se N blank usnews se N blank poc se N blank hcahps se N

local c = 1
foreach cond in $CONDITIONS {
	display "***** WORKING ON `cond' *****"

	foreach spec in baseline poi {
		
		if ("`spec'"=="baseline") {
			local basedir "estimates/alloc_uni/fullsamp/"
			local eq ""
		}
		else if ("`spec'"=="poi") {
			local basedir "estimates/alloc_poisson/"
			local eq "npatients_`cond'_tot:"
		}
		

		* survival
		if (regexm("`cond'","^(ami|chf428|pnu|hip)$")) {
			eboot using `basedir'/`cond'`sampsize'_surv_static, ///
				coeff(`eq'surv_`cond'_eb) nboot($NBOOT) `stderror'
			matrix alloc_poi[1,`c'] = _b[surv_`cond'_eb] \ -_se[surv_`cond'_eb] \ e(N)
		}

		* readmission
		eboot using `basedir'/`cond'`sampsize'_read_static, ///
			coeff(`eq'read_`cond'_eb) nboot($NBOOT) `stderror'
		matrix alloc_poi[5,`c'] = _b[read_`cond'_eb] \ -_se[read_`cond'_eb] \ e(N)
		
		* us news
		if ("`constsamp'"=="fullsamp") {
			if ("`cond'"=="ami" | "`cond'"=="chf428") {
				local usnspec = "heart"
			}
			else if ("`cond'"=="pnu") {
				local usnspec = "resp"
			}
			else if ("`cond'"=="hip" | "`cond'"=="hipkne") {
				local usnspec = "ortho"
			}
			else {
				local usnspec = ""
			}

			eboot using `basedir'/`cond'`sampsize'_usnews_static, ///
				coeff(`eq'`usnspec'_ranked) nboot($NBOOT) `stderror'
			matrix alloc_poi[9,`c'] = _b[`usnspec'_ranked] \ -_se[`usnspec'_ranked] \ e(N)
		}

		* process of care
		if (regexm("`cond'","^(ami|chf428|pnu)$")) {
			eboot using `basedir'/`cond'`sampsize'_poc_static, ///
				coeff(`eq'poc_`cond'_std) nboot($NBOOT) `stderror'
			matrix alloc_poi[13,`c'] = _b[poc_`cond'_std] \ -_se[poc_`cond'_std] \ e(N)
		}

		* hcahps
		eboot using `basedir'/`cond'`sampsize'_hcahps_static, ///
			coeff(`eq'hcahps_std) nboot($NBOOT) `stderror'
		matrix alloc_poi[17,`c'] = _b[hcahps_std] \ -_se[hcahps_std] \ e(N)

		local c = `c' + 1
	}


	local c = `c' + 1
}

putexcel A1=matrix(alloc_poi, names) ///
	using `resultsdir'/alloc_poi`sampsize'.xlsx, replace

matrix alloc_hrr = J(21,14,.)
matrix colnames alloc_hrr = ami_baseline ami_hrr blank chf428_baseline chf428_hrr blank pnu_baseline pnu_hrr blank hip_baseline hip_hrr blank hipkne_baseline hipkne_hrr
matrix rownames alloc_hrr = sharepats blank surv se N blank read se N blank usnews se N blank poc se N blank hcahps se N

local c = 1
foreach cond in $CONDITIONS {
	display "***** WORKING ON `cond' *****"
	
	estimates use estimates/alloc_samehrr/`cond'`sampsize'_read_static/bs0.ster
	matrix alloc_hrr[1,`c'] = 1, e(npatients_hrr)/e(npatients_tot)

	foreach spec in baseline hrr {
		
		if ("`spec'"=="baseline") {
			local basedir "estimates/alloc_uni/fullsamp/"
		}
		else if ("`spec'"=="hrr") {
			local basedir "estimates/alloc_samehrr/"
		}
		

		* survival
		if (regexm("`cond'","^(ami|chf428|pnu|hip)$")) {
			eboot using `basedir'/`cond'`sampsize'_surv_static, ///
				coeff(surv_`cond'_eb) nboot($NBOOT) `stderror'
			matrix alloc_hrr[3,`c'] = _b[surv_`cond'_eb] \ -_se[surv_`cond'_eb] \ e(N)
		}

		* readmission
		eboot using `basedir'/`cond'`sampsize'_read_static, ///
			coeff(read_`cond'_eb) nboot($NBOOT) `stderror'
		matrix alloc_hrr[7,`c'] = _b[read_`cond'_eb] \ -_se[read_`cond'_eb] \ e(N)
		
		* us news
		if ("`constsamp'"=="fullsamp") {
			if ("`cond'"=="ami" | "`cond'"=="chf428") {
				local usnspec = "heart"
			}
			else if ("`cond'"=="pnu") {
				local usnspec = "resp"
			}
			else if ("`cond'"=="hip" | "`cond'"=="hipkne") {
				local usnspec = "ortho"
			}
			else {
				local usnspec = ""
			}

			eboot using `basedir'/`cond'`sampsize'_usnews_static, ///
				coeff(`usnspec'_ranked) nboot($NBOOT) `stderror'
			matrix alloc_hrr[11,`c'] = _b[`usnspec'_ranked] \ -_se[`usnspec'_ranked] \ e(N)
		}

		* process of care
		if (regexm("`cond'","^(ami|chf428|pnu)$")) {
			eboot using `basedir'/`cond'`sampsize'_poc_static, ///
				coeff(poc_`cond'_std) nboot($NBOOT) `stderror'
			matrix alloc_hrr[15,`c'] = _b[poc_`cond'_std] \ -_se[poc_`cond'_std] \ e(N)
		}

		* hcahps
		eboot using `basedir'/`cond'`sampsize'_hcahps_static, ///
			coeff(hcahps_std) nboot($NBOOT) `stderror'
		matrix alloc_hrr[19,`c'] = _b[hcahps_std] \ -_se[hcahps_std] \ e(N)

		local c = `c' + 1
	}


	local c = `c' + 1
}

putexcel A1=matrix(alloc_hrr, names) ///
	using `resultsdir'/alloc_samehrr`sampsize'.xlsx, replace

matrix alloc_trunc = J(19,19,.)
matrix colnames alloc_trunc = ami_baseline ami_ols ami_mle blank chf428_baseline chf428_ols chf428_mle blank pnu_baseline pnu_ols pnu_mle blank hip_baseline hip_ols hip_mle blank hipkne_baseline hipkne_ols hipkne_mle
matrix rownames alloc_trunc = surv se N blank read se N blank usnews se N blank poc se N blank hcahps se N

local c = 1
foreach cond in $CONDITIONS {
	display "***** WORKING ON `cond' *****"

	foreach spec in baseline ols mle {
		
		if ("`spec'"=="baseline") {
			local basedir "estimates/alloc_uni/fullsamp/"
			local postfix "static"
			local eq ""
		}
		else if ("`spec'"=="ols") {
			local basedir "estimates/alloc_trunc/"
			local postfix "xtreg_static"
			local eq ""
		}
		else if ("`spec'"=="mle") {
			local basedir "estimates/alloc_trunc/"
			local postfix "truncreg_static"
			local eq "eq1:"
		}
		

		* survival
		if (regexm("`cond'","^(ami|chf428|pnu|hip)$")) {
			eboot using `basedir'/`cond'`sampsize'_surv_`postfix', ///
				coeff(`eq'surv_`cond'_eb) nboot($NBOOT) `stderror'
			matrix alloc_trunc[1,`c'] = _b[surv_`cond'_eb] \ -_se[surv_`cond'_eb] \ e(N)
		}

		* readmission
		eboot using `basedir'/`cond'`sampsize'_read_`postfix', ///
			coeff(`eq'read_`cond'_eb) nboot($NBOOT) `stderror'
		matrix alloc_trunc[5,`c'] = _b[read_`cond'_eb] \ -_se[read_`cond'_eb] \ e(N)
		
		* us news
		if ("`constsamp'"=="fullsamp") {
			if ("`cond'"=="ami" | "`cond'"=="chf428") {
				local usnspec = "heart"
			}
			else if ("`cond'"=="pnu") {
				local usnspec = "resp"
			}
			else if ("`cond'"=="hip" | "`cond'"=="hipkne") {
				local usnspec = "ortho"
			}
			else {
				local usnspec = ""
			}

			eboot using `basedir'/`cond'`sampsize'_usnews_`postfix', ///
				coeff(`eq'`usnspec'_ranked) nboot($NBOOT) `stderror'
			matrix alloc_trunc[9,`c'] = _b[`usnspec'_ranked] \ -_se[`usnspec'_ranked] \ e(N)
		}

		* process of care
		if (regexm("`cond'","^(ami|chf428|pnu)$")) {
			eboot using `basedir'/`cond'`sampsize'_poc_`postfix', ///
				coeff(`eq'poc_`cond'_std) nboot($NBOOT) `stderror'
			matrix alloc_trunc[13,`c'] = _b[poc_`cond'_std] \ -_se[poc_`cond'_std] \ e(N)
		}

		* hcahps
		eboot using `basedir'/`cond'`sampsize'_hcahps_`postfix', ///
			coeff(`eq'hcahps_std) nboot($NBOOT) `stderror'
		matrix alloc_trunc[17,`c'] = _b[hcahps_std] \ -_se[hcahps_std] \ e(N)

		local c = `c' + 1
	}


	local c = `c' + 1
}

putexcel A1=matrix(alloc_trunc, names) ///
	using `resultsdir'/alloc_trunc`sampsize'.xlsx, replace

matrix alloc_nonednontr = J(19,9,.)
matrix colnames alloc_nonednontr = ami_static chf428_static pnu_static hip_static blank ami_dyn chf428_dyn pnu_dyn hip_dyn
matrix rownames alloc_nonednontr = surv se N blank read se N blank usnews se N blank poc se N blank hcahps se N


local c = 1
foreach alloc in static dyn {
	display "****** `alloc' results *******"
	
	* use poisson for static, "full sample" for dynamic
	if ("`alloc'"=="static") {
		local samp "poisson"
	}
	else {
		local samp "fullsamp"
	}

	foreach cond in $CONDITIONS_ED {
		display "***** WORKING ON `cond' *****"

		* survival
		if (regexm("`cond'","^(ami|chf428|pnu|hip)$")) {
			eboot using estimates/alloc_ednew/`samp'/`cond'`sampsize'_surv_nonednontr_`alloc', nboot($NBOOT) `stderror'
			matrix alloc_nonednontr[1,`c'] = _b[surv_`cond'_eb] \ -_se[surv_`cond'_eb] \ e(N)
		}
	
		* readmission
		eboot using estimates/alloc_ednew/`samp'/`cond'`sampsize'_read_nonednontr_`alloc', nboot($NBOOT) `stderror'
		matrix alloc_nonednontr[5,`c'] = _b[read_`cond'_eb] \ -_se[read_`cond'_eb] \ e(N)
			
		* us news
		if ("`constsamp'"=="`samp'") {
			if ("`cond'"=="ami" | "`cond'"=="chf428") {
				local usnspec = "heart"
			}
			else if ("`cond'"=="pnu") {
				local usnspec = "resp"
			}
			else if ("`cond'"=="hip" | "`cond'"=="hipkne") {
				local usnspec = "ortho"
			}
			else {
				local usnspec = ""
			}

			eboot using estimates/alloc_ednew/`samp'/`cond'`sampsize'_usnews_nonednontr_`alloc', nboot($NBOOT) `stderror'
			matrix alloc_nonednontr[9,`c'] = _b[`usnspec'_ranked] \ -_se[`usnspec'_ranked] \ e(N)
		}

		* process of care
		if (regexm("`cond'","^(ami|chf428|pnu)$")) {
			eboot using estimates/alloc_ednew/`samp'/`cond'`sampsize'_poc_nonednontr_`alloc', nboot($NBOOT) `stderror'
			matrix alloc_nonednontr[13,`c'] = _b[poc_`cond'_std] \ -_se[poc_`cond'_std] \ e(N)
		}
	
		* hcahps
		eboot using estimates/alloc_ednew/`samp'/`cond'`sampsize'_hcahps_nonednontr_`alloc', nboot($NBOOT) `stderror'
		matrix alloc_nonednontr[17,`c'] = _b[hcahps_std] \ -_se[hcahps_std] \ e(N)		

		local c = `c' + 1
	}
	local c = `c' + 1
}

putexcel A1=matrix(alloc_nonednontr, names) ///
	using `resultsdir'/alloc_nonednontr`sampsize'.xlsx, replace

* univariate allocation

foreach constsamp in fullsamp constsamp {

	matrix alloc_uni = J(19,11,.)
	matrix colnames alloc_uni = ami_static chf428_static pnu_static hip_static hipkne_static blank ami_dyn chf428_dyn pnu_dyn hip_dyn hipkne_dyn
	matrix rownames alloc_uni = surv se N blank read se N blank usnews se N blank poc se N blank hcahps se N
	
	local c = 1
	foreach alloc in static dyn {
		display "****** `alloc' results *******"

		foreach cond in $CONDITIONS {
			display "***** WORKING ON `cond' *****"

			* survival
			if (regexm("`cond'","^(ami|chf428|pnu|hip)$")) {
				eboot using estimates/alloc_uni/`constsamp'/`cond'`sampsize'_surv_`alloc', nboot($NBOOT) `stderror'
				matrix alloc_uni[1,`c'] = _b[surv_`cond'_eb] \ -_se[surv_`cond'_eb] \ e(N)
			}
		
			* readmission
			eboot using estimates/alloc_uni/`constsamp'/`cond'`sampsize'_read_`alloc', nboot($NBOOT) `stderror'
			matrix alloc_uni[5,`c'] = _b[read_`cond'_eb] \ -_se[read_`cond'_eb] \ e(N)
				
			* us news
			if ("`constsamp'"=="fullsamp") {
				if ("`cond'"=="ami" | "`cond'"=="chf428") {
					local usnspec = "heart"
				}
				else if ("`cond'"=="pnu") {
					local usnspec = "resp"
				}
				else if ("`cond'"=="hip" | "`cond'"=="hipkne") {
					local usnspec = "ortho"
				}
				else {
					local usnspec = ""
				}

				eboot using estimates/alloc_uni/`constsamp'/`cond'`sampsize'_usnews_`alloc', nboot($NBOOT) `stderror'
				matrix alloc_uni[9,`c'] = _b[`usnspec'_ranked] \ -_se[`usnspec'_ranked] \ e(N)
			}

			* process of care
			if (regexm("`cond'","^(ami|chf428|pnu)$")) {
				eboot using estimates/alloc_uni/`constsamp'/`cond'`sampsize'_poc_`alloc', nboot($NBOOT) `stderror'
				matrix alloc_uni[13,`c'] = _b[poc_`cond'_std] \ -_se[poc_`cond'_std] \ e(N)
			}
		
			* hcahps
			eboot using estimates/alloc_uni/`constsamp'/`cond'`sampsize'_hcahps_`alloc', nboot($NBOOT) `stderror'
			matrix alloc_uni[17,`c'] = _b[hcahps_std] \ -_se[hcahps_std] \ e(N)		

			local c = `c' + 1
		}
		local c = `c' + 1
	}

	if ("`constsamp'"=="constsamp") {
		local fext "uni_constsamp"
	}
	else {
		local fext "uni"
	}
	
	putexcel A1=matrix(alloc_uni, names) ///
		using `resultsdir'/alloc_`fext'`sampsize'.xlsx, replace
}

* multivariate allocation
matrix alloc_mult = J(12,11,.)
matrix colnames alloc_mult = ami_static chf428_static pnu_static hip_static hipkne_static blank ami_dyn chf428_dyn pnu_dyn hip_dyn hipkne_dyn
matrix rownames alloc_mult = surv se read se poc se hcahps se blank N
local c = 1
foreach alloc in static dyn {
	display "****** `alloc' results *******"

	foreach cond in $CONDITIONS {
		display "***** WORKING ON `cond' *****"
		
		eboot using estimates/alloc_multi/`cond'`sampsize'_`alloc', nboot($NBOOT) `stderror'
		
		if ("`cond'"!="hipkne") {
			* add survival & readmission to table
			matrix alloc_mult[1,`c'] = _b[surv_read_`cond'_eb2] \ -_se[surv_read_`cond'_eb2]
			matrix alloc_mult[3,`c'] = _b[read_surv_`cond'_eb2] \ -_se[read_surv_`cond'_eb2]
		}
		else {
			* just readmission for hip/knee (and not bivariate eb adjusted either)
			matrix alloc_mult[3,`c'] = _b[read_`cond'_eb_m] \ -_se[read_`cond'_eb_m]
		}

		* add process of care to table
		if ("`cond'"!="hipkne" & "`cond'"!="hip") {
			matrix alloc_mult[5,`c'] = _b[poc_`cond'_std] \ -_se[poc_`cond'_std]
		}

		* add hcahps to table
		matrix alloc_mult[7,`c'] = _b[hcahps_std] \ -_se[hcahps_std]

		matrix alloc_mult[10,`c'] = e(N)
		
		local c = `c' + 1
	}
	local c = `c' + 1
}
putexcel A1=matrix(alloc_mult, names) using `resultsdir'/alloc_mult`sampsize'.xlsx, replace

* sensitivity to EB adjustment

matrix alloc_sens = J(17,11,.)
matrix colnames alloc_sens = ami_static chf428_static pnu_static hip_static hipkne_static blank ami_dyn chf428_dyn pnu_dyn hip_dyn hipkne_dyn
matrix rownames alloc_sens = surv se N blank surv_raw se N sdrawTOsdadj blank read se N blank read_raw se N sdrawTOsdadj

local c = 1
foreach alloc in static dyn {
	display "****** `alloc' results *******"

	foreach cond in $CONDITIONS {
		display "***** WORKING ON `cond' *****"
	
		* survival
		if (regexm("`cond'","^(ami|chf428|pnu|hip)$")) {
		
			eboot using estimates/alloc_uni/fullsamp/`cond'`sampsize'_surv_`alloc', nboot($NBOOT) `stderror'
			matrix alloc_sens[1,`c'] = _b[surv_`cond'_eb] \ -_se[surv_`cond'_eb] \ e(N)
			
			eboot using estimates/alloc_sens/`cond'`sampsize'_surv_fe_`alloc', nboot($NBOOT) `stderror'
			matrix alloc_sens[5,`c'] = _b[surv_`cond'_fe] \ -_se[surv_`cond'_fe] \ e(N)
			
			* raw SD of survival
			summ surv_`cond'_fe if insamp_`cond'_tot
			local sdraw = r(sd)
			
			* EB-adjusted SD
			summ surv_`cond'_uvar
			local sdadj = sqrt(r(mean))
			
			matrix alloc_sens[8,`c'] = `sdraw'/`sdadj'
		}
	
		* readmission
		eboot using estimates/alloc_uni/fullsamp/`cond'`sampsize'_read_`alloc', nboot($NBOOT) `stderror'
		matrix alloc_sens[10,`c'] = _b[read_`cond'_eb] \ -_se[read_`cond'_eb] \ e(N)

		eboot using estimates/alloc_sens/`cond'`sampsize'_read_fe_`alloc', nboot($NBOOT) `stderror'
		matrix alloc_sens[14,`c'] = _b[read_`cond'_fe] \ -_se[read_`cond'_fe] \ e(N)

		* raw SD of readmission
		summ read_`cond'_fe if insamp_`cond'_tot
		local sdraw = r(sd)
		
		* EB-adjusted SD
		summ read_`cond'_uvar
		local sdadj = sqrt(r(mean))
		
		matrix alloc_sens[17,`c'] = `sdraw'/`sdadj'
		
		local c = `c' + 1
	}
	local c = `c' + 1
}

putexcel A1=matrix(alloc_sens, names) ///
	using `resultsdir'/alloc_ebsens`sampsize'.xlsx, replace


* sensitivity to risk adjustment

matrix alloc_sens = J(23,11,.)
matrix colnames alloc_sens = ami_static chf428_static pnu_static hip_static hipkne_static blank ami_dyn chf428_dyn pnu_dyn hip_dyn hipkne_dyn
matrix rownames alloc_sens = surv se N blank sars se N blank snra N blank read se N blank rars se N blank rnra N

local c = 1
foreach alloc in static dyn {
	display "****** `alloc' results *******"

	foreach cond in $CONDITIONS {
		display "***** WORKING ON `cond' *****"

		local r = 1
		foreach meas in surv sars snra read rars rnra {
		
			if ("`meas'"=="surv" | "`meas'"=="read") {
				* pull survival and readmission w/ full risk adjustment from univariate alloc
				local path "estimates/alloc_uni/fullsamp/`cond'`sampsize'_`meas'_`alloc'"
			}
			else {
				* pull alternative risk adjustment from the sensitivity folder
				local path "estimates/alloc_sens/`cond'`sampsize'_`meas'_eb_`alloc'"
			}
			
			* this if statement will skip over survival for hip/knee replacement
			if ( ///
				(substr("`meas'",1,1)=="s" & regexm("`cond'","^(ami|chf428|pnu|hip)$")) | ///
				substr("`meas'",1,1)=="r" ///
			 ) {

				eboot using `path', nboot($NBOOT) `stderror'
				matrix alloc_sens[`r',`c'] = _b[`meas'_`cond'_eb] \ -_se[`meas'_`cond'_eb] \ e(N)
			}
		
			local r = `r' + 4
		}
				
		local c = `c' + 1
	}
	local c = `c' + 1
}

putexcel A1=matrix(alloc_sens, names) ///
	using `resultsdir'/alloc_rasens`sampsize'.xlsx, replace


* productivity allocation for ami
matrix alloc_prod = J(12,13,.)
matrix colnames alloc_prod = ami ami ami ami ami ami blank ami ami ami ami ami ami
matrix rownames alloc_prod = prsp se prre se spnd se drgw se surv se blank nhosp

local c = 1
foreach alloc in static dyn {
	
	local cond = ""
	
	* allocation wrt productivity (spending)
	eboot using estimates/alloc_prod/ami`sampsize'_prsp_`alloc', nboot($NBOOT) `stderror'
	matrix alloc_prod[1,`c'] = _b[prsp_ami_eb] \ -_se[prsp_ami_eb]
	matrix alloc_prod[12,`c'] = e(N)
	local c = `c' + 1
	
	* allocation wrt productivity (real resources)
	eboot using estimates/alloc_prod/ami`sampsize'_prre_`alloc', nboot($NBOOT) `stderror'
	matrix alloc_prod[3,`c'] = _b[prre_ami_eb] \ -_se[prre_ami_eb]
	matrix alloc_prod[12,`c'] = e(N)
	local c = `c' + 1

	* allocation wrt spending
	eboot using estimates/alloc_prod/ami`sampsize'_spnd_uncond_`alloc', nboot($NBOOT) `stderror'
	matrix alloc_prod[5,`c'] = _b[spnd_ami_eb] \ -_se[spnd_ami_eb]
	matrix alloc_prod[12,`c'] = e(N)
	local c = `c' + 1
	
	* allocation wrt real resources
	eboot using estimates/alloc_prod/ami`sampsize'_drgw_uncond_`alloc', nboot($NBOOT) `stderror'
	matrix alloc_prod[7,`c'] = _b[drgw_ami_eb] \ -_se[drgw_ami_eb]
	matrix alloc_prod[12,`c'] = e(N)
	local c = `c' + 1

	* allocation wrt survival and spending
	eboot using estimates/alloc_prod/ami`sampsize'_spnd_`alloc', nboot($NBOOT) `stderror'
	matrix alloc_prod[5,`c'] = ///
		_b[spnd_surv_ami_eb2] \ -_se[spnd_surv_ami_eb2] \ . \ . \ _b[surv_spnd_ami_eb2] \ -_se[surv_spnd_ami_eb2]
	matrix alloc_prod[12,`c'] = e(N)
	local c = `c' + 1
	
	* allocation wrt survival and resources
	eboot using estimates/alloc_prod/ami`sampsize'_drgw_`alloc', nboot($NBOOT) `stderror'
	matrix alloc_prod[7,`c'] = ///
		 _b[drgw_surv_ami_eb2] \ -_se[drgw_surv_ami_eb2] \ _b[surv_drgw_ami_eb2] \ -_se[surv_drgw_ami_eb2]
	matrix alloc_prod[12,`c'] = e(N)
	local c = `c' + 1

	local c = `c' + 1
}

putexcel A1=matrix(alloc_prod, names) using `resultsdir'/alloc_prod`sampsize'.xlsx, replace

* add some additional stats
matrix prods = J(9,2,.)
matrix colnames prods = spnd drgw
matrix rownames prods = mu_inputs se_inputs sd_productivity sd_survival sd_inputs cor_survival_inputs sd_survival_CNDTL_inputs sd_inputs_CNDTL_survival nhosps

local c = 1
foreach right in spnd drgw {
	if ("`right'"=="drgw") {
		local productivity "prre"
		local inputsmeas "ldrgwt_30"
	}
	else if ("`right'"=="spnd") {
		local productivity "prsp"
		local inputsmeas "lspend_30"
	}
	

	* pull mu (se) from original sample
	estimates use estimates/`productivity'/ami`sampsize'/bs0.ster
	matrix prods[1,`c'] = _b[`inputsmeas'] \ -_se[`inputsmeas']
	
	* stats on productivity from original sample
	preserve
	use counts_allmeas/bs_`sampsize'/bs0.dta, clear
	keep if insamp_ami_tot
	
	* underlying sd of productivity
	qui summ `productivity'_ami_uvar
	local nhosp = r(N)
	matrix prods[3,`c'] = sqrt(r(mean))

	* underlying sd of risk-adj surv
	qui summ surv_`right'_ami_uvar2
	local surv_sd = sqrt(r(mean))
	matrix prods[4,`c'] = `surv_sd'

	* underlying sd of risk-adj res
	qui summ `right'_surv_ami_uvar2
	local inputs_sd = sqrt(r(mean))
	matrix prods[5,`c'] = `inputs_sd'

	* underlying cor of risk-adj surv and risk-adj res
	qui summ surv_`right'_ami_ucov
	local surv_inputs_cov = r(mean)
	local surv_inputs_cor = `surv_inputs_cov'/(`surv_sd'*`inputs_sd')
	matrix prods[6,`c'] = `surv_inputs_cor'

	* sd(risk-adj surv|risk-adj res)
	* formula at https://en.wikipedia.org/wiki/Multivariate_normal_distribution#Bivariate_case
	matrix prods[7,`c'] = sqrt(1-(`surv_inputs_cor'^2))*`surv_sd'

	* sd(risk-adj res|risk-adj surv)
	matrix prods[8,`c'] = sqrt(1-(`surv_inputs_cor'^2))*`inputs_sd'

	* hospitals
	matrix prods[9,`c'] = `nhosp'
	
	restore
	local c = `c' +1
}

putexcel A14=matrix(prods, names) using `resultsdir'/alloc_prod`sampsize'.xlsx, modify

* mechanical allocation
matrix alloc_mech = J(21,11,.)
matrix colnames alloc_mech = ami_static chf428_static pnu_static hip_static hipkne_static blank ami_dyn chf428_dyn pnu_dyn hip_dyn hipkne_dyn
matrix rownames alloc_mech = shareclosest blank surv se N blank read se N blank usnews se N blank poc se N blank hcahps se N

* first: grab stat on % of patients in analysis sample actually going to the
* closest hospital

local c = 1
foreach cond in $CONDITIONS {
	preserve
	
	use counts_allmeas/bs_`sampsize'/bs0.dta, clear
	keep if insamp_`cond'_tot
	
	* patient count from true allocation metric
	qui summ npatients_`cond'_tot
	local totpatients = r(sum)

	* now go to patient level data to calculate share going to closest hosp
	* merge in patient level data 
	keep pn_preboot year
	rename pn_preboot pn
	duplicates drop
	merge 1:m pn year using processed_events/`cond'`sampsize'.dta, ///
		keepusing(chose_closest) keep(match)

	* sanity check that we've captured the same # of patients as embodied in (true) static
	* analysis sample
	count
	assert r(N)==`totpatients'

	* share patients who went to the closest hospital
	summ chose_closest
	matrix alloc_mech[1,`c'] = r(mean)

	restore
	
	local c = `c' + 1
}

* copy the share nearest into the dynamic allocation section
matrix alloc_mech[1,`c'+1] = alloc_mech[1,1..`c'-1]

* now add the regression stats
local c = 1
foreach alloc in static dyn {
	display "****** `alloc' results *******"

	foreach cond in $CONDITIONS {
		display "***** WORKING ON `cond' *****"
		
		* survival
		if (regexm("`cond'","^(ami|chf428|pnu|hip)$")) {
			eboot using estimates/alloc_mech/`cond'`sampsize'_surv_`alloc', nboot($NBOOT) `stderror'
			matrix alloc_mech[3,`c'] = _b[surv_`cond'_eb] \ -_se[surv_`cond'_eb] \ e(N)
		}
		
		* readmission
		eboot using estimates/alloc_mech/`cond'`sampsize'_read_`alloc', nboot($NBOOT) `stderror'
		matrix alloc_mech[7,`c'] = _b[read_`cond'_eb] \ -_se[read_`cond'_eb] \ e(N)

		* us news
		
		if ("`cond'"=="ami" | "`cond'"=="chf428") {
			local usnspec = "heart"
		}
		else if ("`cond'"=="pnu") {
			local usnspec = "resp"
		}
		else if ("`cond'"=="hip" | "`cond'"=="hipkne") {
			local usnspec = "ortho"
		}
		else {
			local usnspec = ""
		}

		eboot using estimates/alloc_mech/`cond'`sampsize'_usnews_`alloc', nboot($NBOOT) `stderror'
		matrix alloc_mech[11,`c'] = _b[`usnspec'_ranked] \ -_se[`usnspec'_ranked] \ e(N)

		* process ofcare
		if (regexm("`cond'","^(ami|chf428|pnu)$")) {
			eboot using estimates/alloc_mech/`cond'`sampsize'_poc_`alloc', nboot($NBOOT) `stderror'
			matrix alloc_mech[15,`c'] = _b[poc_`cond'_std] \ -_se[poc_`cond'_std] \ e(N)
		}
		

		* hcahps
		eboot using estimates/alloc_mech/`cond'`sampsize'_hcahps_`alloc', nboot($NBOOT) `stderror'
		matrix alloc_mech[19,`c'] = _b[hcahps_std] \ -_se[hcahps_std] \ e(N)
		

		local c = `c' + 1
	}
	local c = `c' + 1
}
putexcel A1=matrix(alloc_mech, names) using `resultsdir'/alloc_mech`sampsize'.xlsx, replace


* allocation results split by ed/non-ed

foreach constsamp in fullsamp constsamp poisson {

	matrix alloc_ed = J(49,14,.)
	matrix colnames alloc_ed = ami_ed ami_noned blank chf428_ed chf428_noned blank pnu_ed pnu_noned blank hip_ed hip_noned
	matrix rownames alloc_ed = surv se pval N blank read se pval N blank usnews se pval N blank poc se pval N blank hcahps se pval N blank surv se pval N blank read se pval N blank usnews se pval N blank poc se pval N blank hcahps se pval N

	if ("`constsamp'"=="poisson") {
		local alloclist "static"
	}
	else {
		local alloclist "static dyn"
	}

	foreach alloc in `alloclist' {

		if ("`alloc'"=="static") {
			local r_offset = 1
		}
		else {
			local r_offset = 26
		}
	
		local c = 1

		foreach cond in $CONDITIONS_ED {
		
			* equation names for the SUR
			if ("`constsamp'"=="poisson") {
				local eq_ed "ed_npatients_`cond'_ed"
				local eq_noned "nonedtr_npatients_`cond'_nonedtr"
			}
			else {
				local eq_ed "ed_mean"
				local eq_noned "nonedtr_mean"
			}

			local measures "read usnews hcahps"

			if (regexm("`cond'","^(ami|chf428|pnu|hip)$")) {
				local measures "surv `measures'"
			}

		
			if (regexm("`cond'","^(ami|chf428|pnu)$")) {
				local measures "poc `measures'"
			}
		
			foreach meas in `measures' {
		
				if ("`meas'"=="surv") {
					local rhs = "surv_`cond'_eb"
					local meas_offset = 0
				}
				else if ("`meas'"=="read") {
					local rhs = "read_`cond'_eb"
					local meas_offset = 5
				}
				else if ("`meas'"=="usnews") {
					if ("`cond'"=="ami" | "`cond'"=="chf428") {
						local usnspec = "heart"
					}
					else if ("`cond'"=="pnu") {
						local usnspec = "resp"
					}
					else if ("`cond'"=="hip" | "`cond'"=="hipkne") {
						local usnspec = "ortho"
					}
					else {
						local usnspec = ""
					}
				
					local rhs = "`usnspec'_ranked"
					local meas_offset = 10
				}
				else if ("`meas'"=="poc") {
					local rhs = "poc_`cond'_std"
					local meas_offset = 15
				}
				else if ("`meas'"=="hcahps") {
					local rhs = "hcahps_std"
					local meas_offset = 20
				}
					
				foreach pfx in ed nonedtr {

					local r = `r_offset' + `meas_offset'
				
					display "to row `r' to column `c'"
					
					eboot using estimates/alloc_ednew/`constsamp'/`cond'`sampsize'_`meas'_`pfx'_`alloc', nboot($NBOOT) `stderror'
					matrix alloc_ed[`r',`c'] = _b[`rhs'] \ -_se[`rhs'] \ . \ e(N)
				
					local c = `c' + 1
				}
			
				* test whether static coef was equal between ed and nonedtrans samples
				* we only bootstrap on these two coefficients because, since we run the
				* SUR with hrr FE's as dummies, each replicate run may have a different
				* set of coefficients, and so the bootstrap over all the coefficients
				* would fail
				eboot using estimates/alloc_ednew/`constsamp'/`cond'`sampsize'_`meas'_sur_`alloc', nboot($NBOOT) `stderror' ///
					coeff(`eq_ed':`rhs' `eq_noned':`rhs')
				test [`eq_ed']`rhs'=[`eq_noned']`rhs'

				* pval of difference
				local pval = r(p)
				matrix alloc_ed[`r'+2,`c'-2] = `pval'
			
				local c = `c' - 2
			}
		
			local c = `c' + 3
		}

	}
	
	if ("`constsamp'"=="constsamp") {
		local fext "ednew_constsamp"
	}
	else if ("`constsamp'"=="poisson") {
		local fext "ednew_poi"
	}
	else {
		local fext "ednew"
	}

	putexcel A1=matrix(alloc_ed, names) using `resultsdir'/alloc_`fext'`sampsize'.xlsx, replace
}

log close

