* static and dynamic allocation results and BHC every 3 years, 1996-2008

set more off
capture log close
clear

set matsize 1000

log using logs/alloc_long.log, replace

* set to 0001 or 05 or 20 or 100 to choose sample to work from
local sampsize = "100"

* results dir
local resultsdir = "results/tabledata"

* which conditions with a long survival score
global CONDITIONS_SURV "ami chf428 pnu hip"

* bootstrap count
global NBOOT = 0

* use analytic or bootstrapped standard errors
global ANALYTIC = 1

adopath ++ PLUS
adopath ++ ./ado/

if ($ANALYTIC) {
	local stderror "analytic"
}
else {
	local stderror ""
}

* bootstrap the allocation regressions
forvalues bsidx=0/$NBOOT {

	use counts_allmeas/bs_`sampsize'/bs`bsidx'.dta, clear
	
	* drop down to base years to make regressions faster
	keep if yidx!=.

	* and xtset to the HRR-year level
	egen hrrnum_pn_bootXyear = group(hrrnum_pn_boot year)
	xtset hrrnum_pn_bootXyear
	
	foreach cond in $CONDITIONS_SURV {

		* sample is same as allocation sample for longsurv regression
		gen byte bhc_`cond' = longsamp_`cond'_tot & longsurv_`cond'_fe!=.

		* loop over base years and calculate allocation metrics
		foreach baseyear in 1996 1999 2002 2005 2008 {
		
			foreach meas in longsurv longsars longsnra {
	
				* static allocation
				xtreg lnpatients_`cond'_tot `meas'_`cond'_eb if bhc_`cond' & year==`baseyear', ///
					fe vce(cluster hrrnum_pn_boot)
				capture mkdir estimates/alloc_otime/`baseyear'/`cond'`sampsize'_`meas'_static
				estimates save estimates/alloc_otime/`baseyear'/`cond'`sampsize'_`meas'_static/bs`bsidx'.ster, replace
	
				* dyn`cond'c allocation
				xtreg growth_`cond'_tot `meas'_`cond'_eb if bhc_`cond' & year==`baseyear', ///
					fe vce(cluster hrrnum_pn_boot)
				capture mkdir estimates/alloc_otime/`baseyear'/`cond'`sampsize'_`meas'_dyn
				estimates save estimates/alloc_otime/`baseyear'/`cond'`sampsize'_`meas'_dyn/bs`bsidx'.ster, replace

			}
		}
	}

}

clear

* now do decompositions and display results for each condition

foreach cond in $CONDITIONS_SURV {

	use counts_allmeas/bs_`sampsize'/bs0.dta, clear

	* set up panel data
	xtset pn_boot year

	* generate sample indicators and size and growth measures

	display "***** WORKING ON `cond' *****"

	* bhc sample is same as allocation sample for longsurv regression
	gen byte bhc = longsamp_`cond'_tot & longsurv_`cond'_fe!=.

	* drop down to base years to make regressions faster
	keep if yidx!=.

	* perform BHC decomp at national and market level

	foreach level in national market {
		
		display "* BHC decomp, `level' level"

		if ("`level'" == "national") {
			local bylevel "year"
		}
		else if ("`level'"=="market") {
			local bylevel "hrrnum_pn_boot year"
		}

		preserve
	
		* annual market share
		egen npatients_`cond'_`level' = ///
			sum(npatients_`cond'_tot) if bhc, by(`bylevel')
		gen marketshare = npatients_`cond'_tot/npatients_`cond'_`level' if bhc

		* 3 categories: continuing, entering, exiting
		xtset pn_boot year
		gen byte continuing = bhc & L3.bhc if year >= 1999
		gen byte entering = bhc & !L3.bhc if year >= 1999
		gen byte exiting = !bhc & L3.bhc if year >= 1999

		assert continuing+entering==bhc if year>=1999

		* change in TFP
		gen delta_tfp = longsurv_`cond'_fe - L3.longsurv_`cond'_fe ///
			if continuing==1
		* change in market share
		gen delta_mshare = marketshare - L3.marketshare ///
			if continuing==1
		* change in TPF * change in market share
		gen delta_tfpXmshare = delta_tfp*delta_mshare ///
			if continuing==1

		* market share should sum to 1 within level
		egen total_marketshare = sum(marketshare) if bhc, by(`bylevel')
		assert abs(total_marketshare - 1) < .001 if bhc

		* market share weighted avg TFP
		gen tvar = longsurv_`cond'_fe*marketshare if bhc
		egen weighted_avg_tfp = sum(tvar), by(`bylevel')
		drop tvar total_marketshare

		* temporary sums to construct the BHC terms

		gen tsum_avg_tfp = longsurv_`cond'_fe*marketshare if bhc
	
		gen tsum_within = L3.marketshare*delta_tfp if continuing==1

		gen tsum_between = (L3.longsurv_`cond'_fe - L3.weighted_avg_tfp)*delta_mshare if continuing==1

		gen tsum_cross = delta_tfp*delta_mshare if continuing==1

		gen tsum_entry = marketshare*(longsurv_`cond'_fe - L3.weighted_avg_tfp) if entering==1

		gen tsum_exit = L3.marketshare*(L3.longsurv_`cond'_fe - L3.weighted_avg_tfp) if exiting==1
	
		* add up the temporary sums, move to year level
		collapse (sum) ///
			weighted_avg_tfp_check = tsum_avg_tfp ///
			within = tsum_within ///
			between = tsum_between ///
			cross = tsum_cross ///
			entry = tsum_entry ///
			exit = tsum_exit ///
			continuing exiting entering ///
			npatients_`cond'_tot ///
			(mean) weighted_avg_tfp, by(`bylevel')

		* did the weighted avg tfp calculated the alternative way match?
		assert abs(weighted_avg_tfp_check - weighted_avg_tfp) < .0001
		drop weighted_avg_tfp_check

		* change in TFP
		tsset `bylevel'
		gen delta_tfp = weighted_avg_tfp - L3.weighted_avg_tfp

		* the decomp is now 0 for 1996 because collapse makes missing into 0
		* reset to missing
		foreach var of varlist within between cross entry exit {
			replace `var' = . if year==1996
		}

		* summed components of the change
		gen tot = within + between + cross + entry - exit
	
		* they better equal the total change
		list tot delta_tfp within between cross entry exit if year>=1999 & abs(tot - delta_tfp) >= .0001
		assert abs(tot - delta_tfp) < .0001 if year>=1999
		drop tot

		* to a matrix
		if ("`level'"=="national") {
			mkmat delta_tfp within between cross entry exit , rownames(year) matrix(bhc_`level')
			list
		}
		else if ("`level'"=="market") {
			* use last year's patient count as weight
			gen pats_lastyear = L3.npatients_`cond'_tot
			collapse ///
				(mean) delta_tfp within between cross entry exit ///
				[aw=pats_lastyear], by(year)

			* we lost 1996. make a new row and add it back
			local newobs = _N+1
			set obs `newobs'
			replace year = 1996 if year==.

			sort year
			mkmat delta_tfp within between cross entry exit , ///
				rownames(year) matrix(bhc_`level')
			list
		}

		matrix bhc_`level' = bhc_`level''

		restore

	}

	egen npatients_`cond'_national = sum(npatients_`cond'_tot) if bhc, by(year)
	gen marketshare = npatients_`cond'_tot/npatients_`cond'_national if bhc

	* and xtset to the HRR-year level
	egen hrrnum_pn_bootXyear = group(hrrnum_pn_boot year)
	xtset hrrnum_pn_bootXyear

	matrix alloc_otime = J(30,5,.)

	matrix colnames alloc_otime = 1996 1999 2002 2005 2008
	matrix rownames alloc_otime = ///
		static se N blank dynamic se N blank blank ///
		mwavg rawavg opcov opcor N blank blank ///
		tot_NATL within between cross entry exit blank blank ///
		tot_MKT_MEAN within between cross entry exit

	* loop over base years and calculate allocation metrics
	local c = 1
	foreach baseyear in 1996 1999 2002 2005 2008 {
	
		* static allocation
		eboot using estimates/alloc_otime/`baseyear'/`cond'`sampsize'_longsurv_static, nboot($NBOOT) `stderror'
		matrix alloc_otime[1,`c'] = _b[longsurv_`cond'_eb] \ -_se[longsurv_`cond'_eb] \ e(N)
	
		* dynamic allocation
		eboot using estimates/alloc_otime/`baseyear'/`cond'`sampsize'_longsurv_dyn, nboot($NBOOT) `stderror'
		matrix alloc_otime[5,`c'] = _b[longsurv_`cond'_eb] \ -_se[longsurv_`cond'_eb] \ e(N)
	
		* market-weighted avg survival
		summ longsurv_`cond'_fe if bhc & year==`baseyear' [aw=marketshare]
		matrix alloc_otime[10,`c'] = r(mean)
	
		* raw avg survival
		summ longsurv_`cond'_fe if bhc & year==`baseyear'
		matrix alloc_otime[11,`c'] = r(mean)
	
		* op-covariance and op-correlation
		
		* first covariance and raw variance components
		correl marketshare longsurv_`cond'_fe if bhc & year==`baseyear', ///
			covariance	
		local covar = r(cov_12)
		local var_lnp = r(Var_1)
		local var_surv = r(Var_2)
		local N = r(N)
	
		* variance of survival includes measurement error. remove it
		gen s2 = longsurv_`cond'_se^2
		summ s2 if bhc & year==`baseyear'
		assert r(N) == `N'
		local var_surv = `var_surv' - r(mean)
	
		local correl = `covar'/sqrt(`var_lnp'*`var_surv')
		display "covar: `covar' correl: `correl'"
	
		* op-covariance is covariance * N
		local opcov = `covar'*`N'

		drop s2
	
		matrix alloc_otime[12,`c'] = `opcov' \ `correl' \ `N'
		
		local c = `c' + 1
	}

	* add bhc to matrix
	matrix alloc_otime[17,1] = bhc_national
	matrix alloc_otime[25,1] = bhc_market

	putexcel A1=matrix(alloc_otime, names) using `resultsdir'/alloc_otime_`cond'`sampsize'.xlsx, replace
}

log close

