* static and dynamic allocation and BHC results from 1996 to 2008 in one swoop

set more off
capture log close
clear

set matsize 1000

log using logs/alloc_longer.log, replace

* set to 0001 or 05 or 20 or 100 to choose sample to work from
local sampsize = "100"

* results dir
local resultsdir = "results/tabledata"

* which conditions with a long survival score
global CONDITIONS_SURV "ami chf428 pnu hip"

* bootstrap count
global NBOOT = 0

* which patient is the survival decomposition supposed to be for?
* if 0 - for a patient with all risk adjusters off
* if 1 - for the average patient in each market-year (survival scores centered at
* raw survival rate for that market-year

global RISKFACTORADJUST = 1

* use analytic or bootstrapped standard errors
global ANALYTIC = 1

adopath ++ PLUS
adopath ++ ./ado/

if ($ANALYTIC) {
	local stderror "analytic"
}
else {
	local stderror ""
}

* lower limit on number of patients when estimating risk-adjusted rates
if ("`sampsize'"!="100") {
	global MINPATS = 5
}
else {
	global MINPATS = 25
}

* risk adjusters

global RISKADJUSTERS "ARSINDIC_* como_* card_*"


* now do decompositions and display results for each condition

foreach cond in $CONDITIONS_SURV {
	
	* calculate the risk adjustment factor with the patient set to have risk adjusters
	* of average of whole sample

	use counts_allmeas/bs_`sampsize'/bs0.dta, clear

	* set up panel data
	xtset pn_boot year

	* generate sample indicators and size and growth measures

	display "***** WORKING ON `cond' *****"

	* bhc sample is same as allocation sample for longsurv regression
	gen byte bhc = longsamp_`cond'_tot & longsurv_`cond'_fe!=.

	* drop down to base years to make regressions faster
	keep if yidx!=.
	
	* drop down first and last yidx (-3 and 1)
	keep if yidx==-3 | yidx==1
	
	* recenter at year's average of hospital level raw average survival
	
	* perform BHC decomp at national and market level

	foreach level in national market {
		
		display "* BHC decomp, `level' level"

		if ("`level'" == "national") {
			local bylevel "year"
		}
		else if ("`level'"=="market") {
			local bylevel "hrrnum_pn_boot year"
		}

		preserve
		
		if ($RISKFACTORADJUST) {
			* center patient-weighted risk-adj survival in each market to the
			* patient-weighted raw survival in each market
			
			/*
			* this would use the number of patients embodied in the risk-adj survival
			* measure, which spans 3 years
			egen longsurv_offset = wtmean(longsnra_`cond'_fe) if bhc, ///
				weight(longsurv_`cond'_npats) by(`bylevel')		
			egen longsurv_mean = wtmean(longsurv_`cond'_fe) if bhc, ///
				weight(longsurv_`cond'_npats) by(`bylevel')
			*/
			
			* this approach uses number of patients in the terminal year as the weight
			* (matches the approach we describe in the text)
			egen longsurv_offset = wtmean(longsnra_`cond'_fe) if bhc, ///
				weight(npatients_`cond'_tot) by(`bylevel')		
			egen longsurv_mean = wtmean(longsurv_`cond'_fe) if bhc, ///
				weight(npatients_`cond'_tot) by(`bylevel')
			
			//tab longsurv_mean longsurv_offset if bhc
			replace longsurv_`cond'_fe = ///
				longsurv_`cond'_fe - longsurv_mean + longsurv_offset
			drop longsurv_mean longsurv_offset
			mean longsurv_`cond'_fe if bhc, over(yidx)
		}
	
		* annual market share
		egen npatients_`cond'_`level' = ///
			sum(npatients_`cond'_tot) if bhc, by(`bylevel')
		gen marketshare = npatients_`cond'_tot/npatients_`cond'_`level' if bhc

		* 3 categories: continuing, entering, exiting
		xtset pn_boot year
		gen byte continuing = bhc & L12.bhc if year >= 1999
		gen byte entering = bhc & !L12.bhc if year >= 1999
		gen byte exiting = !bhc & L12.bhc if year >= 1999

		assert continuing+entering==bhc if year>=1999

		* change in TFP
		gen delta_tfp = longsurv_`cond'_fe - L12.longsurv_`cond'_fe ///
			if continuing==1
		* change in market share
		gen delta_mshare = marketshare - L12.marketshare ///
			if continuing==1
		* change in TPF * change in market share
		gen delta_tfpXmshare = delta_tfp*delta_mshare ///
			if continuing==1

		* market share should sum to 1 within level
		egen total_marketshare = sum(marketshare) if bhc, by(`bylevel')
		assert abs(total_marketshare - 1) < .001 if bhc

		* market share weighted avg TFP
		gen tvar = longsurv_`cond'_fe*marketshare if bhc
		egen weighted_avg_tfp = sum(tvar), by(`bylevel')
		drop tvar total_marketshare

		* temporary sums to construct the BHC terms

		gen tsum_avg_tfp = longsurv_`cond'_fe*marketshare if bhc
	
		gen tsum_within = L12.marketshare*delta_tfp if continuing==1

		gen tsum_between = (L12.longsurv_`cond'_fe - L12.weighted_avg_tfp)*delta_mshare if continuing==1

		gen tsum_cross = delta_tfp*delta_mshare if continuing==1

		gen tsum_entry = marketshare*(longsurv_`cond'_fe - L12.weighted_avg_tfp) if entering==1

		gen tsum_exit = L12.marketshare*(L12.longsurv_`cond'_fe - L12.weighted_avg_tfp) if exiting==1
	
		* add up the temporary sums, move to year/market-year level
		collapse (sum) ///
			weighted_avg_tfp_check = tsum_avg_tfp ///
			within = tsum_within ///
			between = tsum_between ///
			cross = tsum_cross ///
			entry = tsum_entry ///
			exit = tsum_exit ///
			continuing exiting entering ///
			npatients_`cond'_tot ///
			(mean) weighted_avg_tfp, by(`bylevel')

		* did the weighted avg tfp calculated the alternative way match?
		assert abs(weighted_avg_tfp_check - weighted_avg_tfp) < .0001
		drop weighted_avg_tfp_check

		* change in TFP
		tsset `bylevel'
		gen delta_tfp = weighted_avg_tfp - L12.weighted_avg_tfp

		* the decomp is now 0 for 1996 because collapse makes missing into 0
		* reset to missing
		foreach var of varlist within between cross entry exit {
			replace `var' = . if year==1996
		}

		* summed components of the change
		gen tot = within + between + cross + entry - exit
	
		* they better equal the total change
		list tot delta_tfp within between cross entry exit if year>=1999 & abs(tot - delta_tfp) >= .0001
		assert abs(tot - delta_tfp) < .0001 if year>=1999
		drop tot

		* to a matrix
		if ("`level'"=="national") {
			mkmat delta_tfp within between cross entry exit , rownames(year) matrix(bhc_`level')
			list
		}
		else if ("`level'"=="market") {
			* get market sizes for 1996 to use as weights
			egen pats1996 = max(npatients_`cond'_tot*(year==1996)), ///
				by(hrrnum_pn_boot )
		
			collapse ///
				(mean) delta_tfp within between cross entry exit ///
				[aw=pats1996], by(year)
			sort year
			mkmat delta_tfp within between cross entry exit , ///
				rownames(year) matrix(bhc_`level')
			list
		}
		
		matrix bhc_`level' = bhc_`level''

		restore

	}
	
	matrix alloc_otime = J(14,2,.)

	matrix colnames alloc_otime = 1996 2008
	matrix rownames alloc_otime = ///
		tot_NATL within between cross entry exit blank blank ///
		tot_MKT_MEAN within between cross entry exit ///

	* add bhc to matrix
	matrix alloc_otime[1,1] = bhc_national
	matrix alloc_otime[9,1] = bhc_market

	putexcel A1=matrix(alloc_otime, names) using `resultsdir'/alloc_longer_`cond'`sampsize'.xlsx, replace
}

log close

