use "oblastlevel.dta", clear

**nazipj, nazi dummy interacted with percent Jews in 1939

gen nazipj=nazi*pj39
replace nazipj=0 if nazi==0
label variable nazipj "Percent Jewish Pop. '39 x Occupation"

**nazipj26, nazi dummy interacted with percent Jews in 1926

gen nazipj26=nazi*pj26
replace nazipj26=0 if nazi==0
label variable nazipj26 "Percent Jewish Pop.~'26 x Occupation"

**nazipj26, nazi dummy interacted with percent Jews in 1937

gen nazipj37=nazi*pj37
replace nazipj37=0 if nazi==0
label variable nazipj37 "Percent Jewish Pop. '37 x Occupation"

**nazipjmnarrow, nazi dummy interacted with percentage of narrow middle class made up by jews

gen pjnarrowmc=jnarrowmc/tnarrowmc*100
label variable pjnarrowmc "Percent narrow MC J"

gen nazipjmnarrow=nazi*pjnarrowmc
replace nazipjmnarrow=0 if nazi==0
label variable nazipjmnarrow "Percent Middle Class Jews~'39 x Occ."
label variable nazipjmnarrow "Percent Middle Class Jews~'39 x Occupation"

**absolute change in the number of Jews

gen dj=j59-j39
gen dj37=j59-j37

**dmdth, change in percent middle class due to holocaust

gen dmdth=m39-(tbroadmc+dj*tp39active*jbroadmc/j39active  )/(t39active+dj*tp39active)*100
replace dmdth=0 if j70==. & j59sto==. & rus==1 & nazi==0
label variable dmdth "Ex-post Impact on middle class"
gen dmdth37=m39-(tbroadmc+dj37*tp39active*jbroadmc/j39active  )/(t39active+dj*tp39active)*100
replace dmdth37=0 if j70==. & j59sto==. & rus==1 & nazi==0
label variable dmdth37 "Ex-post Impact on middle class ('37 data)"

**dmdth with Narrow Middle Class


gen dmdthnarrow=tnarrowmc/t39active*100-(tnarrowmc+dj*tp39active*jnarrowmc/j39active)/(t39active+dj*tp39active)*100
replace dmdthnarrow=0 if j70==. & j59sto==. & rus==1 & nazi==0
label variable dmdthnarrow "Ex-post Impact on Middle Class"
gen dmdthnarrow37=tnarrowmc/t39active*100-(tnarrowmc+dj37*tp39active*jnarrowmc/j39active)/(t39active+dj37*tp39active)*100
replace dmdthnarrow37=0 if j70==. & j59sto==. & rus==1 & nazi==0
label variable dmdthnarrow37 "Ex-post Impact on Middle Class ('37 data)"

**Change in overall population

gen dlogpop=log(t39pop_59)-log(pop59)

**change in population in occuied areas

gen dlogpopnazi=dlogpop*nazi
label variable dlogpopnazi "Ex-post Pop. Change x Occupation"

**labels for plots

gen oblastname2=oblastname
replace oblastname2=" " if nazi==0

gen oblastname3=oblastname
replace oblastname3="" if dmdth==0


**Table I Descriptive Stats

gen nazihighpj39=0
replace nazihighpj39=1 if nazi==1& pj39>0.593

local descriptive tp39urban m39 pj39 m59 m89 p89urban gdp02 averagewage02 referendum communistvote em39 em45 em89

*tablemat `descriptive' if rus==1 & nazipj!=. &lnut39pop!=.&pj39!=., stat(mean)  by(nazi nazihighpj39)
*tablemat `descriptive' if rus==1 & nazipj!=. &lnut39pop!=.&pj39!=., stat(sd)  by(nazi nazihighpj39)
*tablemat `descriptive' if rus==1 & nazipj!=. &lnut39pop!=.&pj39!=., stat(n)  by(nazi nazihighpj39)


**Table VI

**Panels A & B

local standardcontrols lnm39abs oil delta_em_imp delta_ed_imp 

reg lnm89 nazipj nazi pj39 lnut39pop_59 deglat deglong lnpop89 `standardcontrols' [aweight=t39pop], robust
estimates store drI, title(" ") 
reg lnm89 nazipjmnarrow nazi pj39 pjnarrowmc  lnut39pop_59 deglat deglong lnpop89 `standardcontrols' [aweight=t39pop] , robust
estimates store drII, title(" ") 
reg lnm89 dmdthnarrow nazi pj39 lnut39pop_59 deglat deglong lnpop89 `standardcontrols' [aweight=t39pop] , robust
estimates store drIII, title(" ") 
reg lnm89 dmdthnarrow nazi pj39 lnut39pop_59 deglat deglong lnpop89 `standardcontrols' , robust
estimates store drIV, title(" ") 
reg lnm89 dmdthnarrow nazi pj39 lnut39pop_59 deglat deglong lnpop89 `standardcontrols' pj89 [aweight=t39pop], robust
estimates store drV, title(" ") 
reg lnm89 dmdthnarrow nazi pj39 lnut39pop_59 deglat deglong lnpop89 `standardcontrols' dlogpopnazi dlogpop [aweight=t39pop], robust
estimates store drVI, title(" ") 
estout drI drII drIII drIV drV drVI using regtable6final_lnm89.tex, replace style(tex) ml( ,none) order(nazipj nazipjmnarrow dmdthnarrow) drop(_cons  `standardcontrols' nazi pjnarrowmc `interaction' pj39 pj89  lnue89 nazidur deglong deglat lnut39pop_59 lnpop39_59 dlogpop pj89 dlogpopnazi lnpop*, relax) collabels(, none) label cells(b(nostar fmt(%9.3f)) se(par)) starlevels(+ 0.10 * 0.05 ** 0.01)


quietly: reg lnm70 nazipj nazi pj39 lnut39pop_59 deglat deglong lnpop70 `standardcontrols' [aweight=t39pop], robust
estimates store drI, title(" ") 
reg lnm70 nazipjmnarrow nazi pj39 pjnarrowmc  lnut39pop_59 deglat deglong lnpop70 `standardcontrols' [aweight=t39pop] , robust
estimates store drII, title(" ") 
quietly: reg lnm70 dmdthnarrow nazi pj39 lnut39pop_59 deglat deglong lnpop70 `standardcontrols' [aweight=t39pop] , robust
estimates store drIII, title(" ") 
quietly: reg lnm70 dmdthnarrow nazi pj39 lnut39pop_59 deglat deglong lnpop70 `standardcontrols' , robust
estimates store drIV, title(" ") 
reg lnm70 dmdthnarrow nazi pj39 lnut39pop_59 deglat deglong lnpop70 `standardcontrols' pj89 [aweight=t39pop], robust
estimates store drV, title(" ") 
quietly: reg lnm70 dmdthnarrow nazi pj39 lnut39pop_59 deglat deglong lnpop70 `standardcontrols' dlogpopnazi dlogpop [aweight=t39pop], robust
estimates store drVI, title(" ") 
estout drI drII drIII drIV drV drVI using regtable6final_lnm70.tex, replace style(tex) ml( ,none) order(nazipj nazipjmnarrow dmdthnarrow) drop(_cons  `standardcontrols' nazi pjnarrowmc `interaction' pj39 pj89  lnue89 nazidur deglong deglat lnut39pop_59 lnpop39_59 dlogpop pj89 dlogpopnazi lnpop*, relax) collabels(, none) label cells(b(nostar fmt(%9.3f)) se(par)) starlevels(+ 0.10 * 0.05 ** 0.01)


*regressions mentioned in footnote

reg lnm89 dmdth nazi pj39 lnut39pop_59 deglat deglong lnpop89 `standardcontrols' [aweight=t39pop] , robust
reg lnm70 dmdth nazi pj39 lnut39pop_59 deglat deglong lnpop70 `standardcontrols' [aweight=t39pop] , robust

*regressions mentioned in text

rreg lnm89 dmdthnarrow nazi pj39 lnut39pop_59 deglat deglong lnpop89 lnm39abs oil delta_em_imp delta_ed_imp
rreg lnm70 dmdthnarrow nazi pj39 lnut39pop_59 deglat deglong lnpop89 lnm39abs oil delta_em_imp delta_ed_imp
reg lnm39abs nazipj26 nazi pj26 lnut26pop deglat deglong lnpop39 lnm26 oil delta_em_imp delta_ed_imp if pj39!=., robust
reg lnm39abs nazipj26 nazi pj26 lnut26pop deglat deglong lnpop39 lnm26 oil delta_em_imp delta_ed_imp [aweight=t39pop] if pj39!=., robust


**Panels C, D & E

local outcomes lngdp02 lnavw02 lnreferendum 
local standardcontrols lnm39abs oil  delta_em_imp delta_ed_imp

foreach x in `outcomes'{

reg `x' nazipj nazi pj39 lnut39pop_59 deglat deglong `standardcontrols' [aweight=t39pop], robust
estimates store drI, title(" ") 
reg `x' nazipjmnarrow nazi pj39 pjnarrowmc  lnut39pop_59 deglat deglong `standardcontrols' [aweight=t39pop] , robust
estimates store drII, title(" ") 
reg `x' dmdthnarrow nazi pj39 lnut39pop_59 deglat deglong `standardcontrols' [aweight=t39pop] , robust
estimates store drIII, title(" ") 
reg `x' dmdthnarrow nazi pj39 lnut39pop_59 deglat deglong `standardcontrols' , robust
estimates store drIV, title(" ") 
reg `x' dmdthnarrow  nazi pj39 lnut39pop_59 deglat deglong `standardcontrols' pj89 [aweight=t39pop], robust
estimates store drV, title(" ") 
reg `x' dmdthnarrow nazi pj39 lnut39pop_59 deglat deglong `standardcontrols' dlogpopnazi dlogpop [aweight=t39pop] , robust
estimates store drVI, title(" ") 

disp "********************`x'****************************"

estout drI drII drIII drIV drV drVI using regtable6final_`x'.tex, replace style(tex) ml( ,none) order(nazipj  nazipjmnarrow dmdthnarrow) drop(_cons pjnarrowmc `standardcontrols' nazi `interaction' pj39 pj89  lnue89 nazidur deglong deglat lnut39pop_59 lnpop39_59 dlogpop pj89 dlogpopnazi, relax) collabels(, none) label cells(b(nostar fmt(%9.3f)) se(par)) starlevels(+ 0.10 * 0.05 ** 0.01)
} 


label variable nazipjmnarrow "Percent Middle Class Jews~'39 x Occ."

*regressions mentioned in text

rreg lnreferendum dmdthnarrow nazi pj39 lnut39pop_59 deglat deglong lnm39abs oil  delta_em_imp delta_ed_imp  


**Table A.3

local outcomes 89 79 59
local standardcontrols lnm39abs oil delta_em_imp delta_ed_imp

foreach x in `outcomes'{
quietly: reg lnm`x' nazipj nazi pj39 lnut39pop_59 deglat deglong lnpop`x' `standardcontrols' , robust
estimates store drI, title(" ") 
quietly: reg lnm`x' nazipj nazi pj39 lnut39pop_59 deglat deglong lnpop`x' `standardcontrols' [aweight=t39pop], robust
estimates store drII, title(" ") 
quietly: reg lnm`x' nazipjmnarrow nazi pj39 pjnarrowmc lnut39pop_59 deglat deglong lnpop`x' `standardcontrols' , robust
estimates store drIII, title(" ") 
reg lnm`x' nazipjmnarrow nazi pj39 pjnarrowmc  lnut39pop_59 deglat deglong lnpop`x' `standardcontrols' [aweight=t39pop] , robust
estimates store drIV, title(" ") 
reg lnm`x' nazipjmnarrow nazi pj39 pjnarrowmc  lnut39pop_59 deglat deglong lnpop`x' `standardcontrols' pj89 [aweight=t39pop] , robust
estimates store drV, title(" ") 
quietly: reg lnm`x' dmdthnarrow nazi pj39 lnut39pop_59 deglat deglong lnpop`x' `standardcontrols' , robust
estimates store drVI, title(" ") 
quietly: reg lnm`x' dmdthnarrow nazi pj39 lnut39pop_59 deglat deglong lnpop`x' `standardcontrols' [aweight=t39pop] , robust
estimates store drVII, title(" ") 
reg lnm`x' dmdthnarrow nazi pj39 lnut39pop_59 deglat deglong lnpop`x' `standardcontrols' pj89 [aweight=t39pop], robust
estimates store drVIII, title(" ") 
quietly: reg lnm`x' dmdthnarrow nazi pj39 lnut39pop_59 deglat deglong lnpop`x' `standardcontrols' dlogpopnazi dlogpop [aweight=t39pop], robust
estimates store drIX, title(" ") 

disp "********************`x'****************************"

estout drI drII drIII drIV drV drVI drVII drVIII drIX using regtemplate2lnm`x'.tex, replace style(tex) ml( ,none) order(nazipj nazipjmnarrow dmdthnarrow) drop(_cons  `standardcontrols' nazi pjnarrowmc `interaction' pj39 pj89  lnue89 nazidur deglong deglat lnut39pop_59 lnpop39_59 dlogpop pj89 dlogpopnazi lnpop*, relax) collabels(, none) label cells(b(nostar fmt(%9.3f)) se(par)) starlevels(+ 0.10 * 0.05 ** 0.01)
estout drI drII drIII drIV drV drVI drVII drVIII drIX using regtemplate2fulllnm`x'.tex, replace style(tex) ml( ,none) order(nazipj  nazipjmnarrow dmdthnarrow) drop(_cons  ) collabels(, none) label cells(b(nostar fmt(%9.3f)) se(par)) stats( N, fmt( %9.0g)labels( "N")) starlevels(+ 0.10 * 0.05 ** 0.01)
} 


**Table A.4

local outcomes lnavw02 lnreferendum lngdp02  lnelect2 
local standardcontrols lnm39abs oil  delta_em_imp delta_ed_imp

foreach x in `outcomes'{
quietly: reg `x' nazipj nazi pj39 lnut39pop_59 deglat deglong `standardcontrols' , robust
estimates store drI, title(" ") 
quietly: reg `x' nazipj nazi pj39 lnut39pop_59 deglat deglong `standardcontrols' [aweight=t39pop], robust
estimates store drII, title(" ") 
quietly: reg `x' nazipjmnarrow nazi pj39 pjnarrowmc  lnut39pop_59 deglat deglong `standardcontrols' , robust
estimates store drIII, title(" ") 
quietly: reg `x' nazipjmnarrow nazi pj39 pjnarrowmc  lnut39pop_59 deglat deglong `standardcontrols' [aweight=t39pop] , robust
estimates store drIV, title(" ") 
quietly: reg `x' nazipjmnarrow nazi pj39 pjnarrowmc  lnut39pop_59 deglat deglong `standardcontrols' pj89 [aweight=t39pop] , robust
estimates store drV, title(" ") 
quietly: reg `x' dmdthnarrow nazi pj39 lnut39pop_59 deglat deglong `standardcontrols' , robust
estimates store drVI, title(" ") 
quietly: reg `x' dmdthnarrow nazi pj39 lnut39pop_59 deglat deglong `standardcontrols' [aweight=t39pop] , robust
estimates store drVII, title(" ") 
quietly: reg `x' dmdthnarrow  nazi pj39 lnut39pop_59 deglat deglong `standardcontrols' pj89 [aweight=t39pop], robust
estimates store drVIII, title(" ") 
quietly: reg `x' dmdthnarrow nazi pj39 lnut39pop_59 deglat deglong `standardcontrols' dlogpopnazi dlogpop [aweight=t39pop] , robust
estimates store drIX, title(" ") 

disp "********************`x'****************************"

estout drI drII drIII drIV drV drVI drVII drVIII drIX using regtemplate2`x'.tex, replace style(tex) ml( ,none) order(nazipj  nazipjmnarrow dmdthnarrow) drop(_cons pjnarrowmc `standardcontrols' nazi `interaction' pj39 pj89  lnue89 nazidur deglong deglat lnut39pop_59 lnpop39_59 dlogpop pj89 dlogpopnazi, relax) collabels(, none) label cells(b(nostar fmt(%9.3f)) se(par)) starlevels(+ 0.10 * 0.05 ** 0.01)
estout drI drII drIII drIV drV drVI drVII drVIII drIX using regtemplate2full`x'.tex, replace style(tex) ml( ,none) order(nazipj  nazipjmnarrow dmdthnarrow) drop(_cons  ) collabels(, none) label cells(b(nostar fmt(%9.3f)) se(par)) stats(r2_a N, fmt(%9.3f %9.0g)labels("\$R^2\$" "N")) starlevels(+ 0.10 * 0.05 ** 0.01)
} 


**Table A.5

local outcomes lnue89 
local standardcontrols lnm39abs oil lnpop89 delta_em_imp delta_ed_imp

foreach x in `outcomes'{
quietly: reg `x' nazipj nazi pj39 lnut39pop_59 deglat deglong `standardcontrols' , robust
estimates store drI, title(" ") 
quietly: reg `x' nazipj nazi pj39 lnut39pop_59 deglat deglong `standardcontrols' [aweight=t39pop] , robust
estimates store drII, title(" ") 
quietly: reg `x' nazipjmnarrow nazi pj39 pjnarrowmc lnut39pop_59 deglat deglong `standardcontrols' , robust
estimates store drIII, title(" ") 
quietly: reg `x' nazipjmnarrow nazi pj39 pjnarrowmc lnut39pop_59 deglat deglong `standardcontrols' [aweight=t39pop] , robust
estimates store drIV, title(" ") 
quietly: reg `x' nazipjmnarrow nazi pj39 pjnarrowmc lnut39pop_59 deglat deglong `standardcontrols' pj89 [aweight=t39pop] , robust
estimates store drV, title(" ") 
quietly: reg `x' dmdthnarrow nazi pj39 lnut39pop_59 deglat deglong `standardcontrols' , robust
estimates store drVI, title(" ") 
quietly: reg `x' dmdthnarrow nazi pj39 lnut39pop_59 deglat deglong `standardcontrols' [aweight=t39pop] , robust
estimates store drVII, title(" ") 
quietly: reg `x' dmdthnarrow nazi pj39 lnut39pop_59 deglat deglong `standardcontrols' pj89 [aweight=t39pop] , robust
estimates store drVIII, title(" ") 
quietly: reg `x' dmdthnarrow nazi pj39 lnut39pop_59 deglat deglong `standardcontrols' dlogpopnazi dlogpop [aweight=t39pop] , robust
estimates store drIX, title(" ")

disp "********************`x'****************************"

estout drI drII drIII drIV drV drVI drVII drVIII drIX using regtemplate2`x'.tex, replace style(tex) ml( ,none) order(nazipj nazipjmnarrow dmdthnarrow) keep(nazipj nazipjmnarrow dmdthnarrow)  collabels(, none) label cells(b(nostar fmt(%9.3f)) se(par)) starlevels(+ 0.10 * 0.05 ** 0.01)
quietly: estout drI drII drIII drIV drV drVI drVII drVIII drIX using regtemplate2full`x'.tex, replace style(tex) ml( ,none) order(nazipj  dmdth) drop(_cons ukr bel pol, relax ) collabels(, none) label cells(b(nostar fmt(%9.3f)) se(par)) stats( N, fmt( %9.0g)labels( "N")) starlevels(+ 0.10 * 0.05 ** 0.01)
} 


local outcomes lnue79 
local standardcontrols lnm39abs oil lnpop79 delta_em_imp delta_ed_imp

foreach x in `outcomes'{
quietly: reg `x' nazipj nazi pj39 lnut39pop_59 deglat deglong `standardcontrols' , robust
estimates store drI, title(" ") 
quietly: reg `x' nazipj nazi pj39 lnut39pop_59 deglat deglong `standardcontrols' [aweight=t39pop] , robust
estimates store drII, title(" ") 
quietly: reg `x' nazipjmnarrow nazi pj39 pjnarrowmc lnut39pop_59 deglat deglong `standardcontrols' , robust
estimates store drIII, title(" ") 
quietly: reg `x' nazipjmnarrow nazi pj39 pjnarrowmc lnut39pop_59 deglat deglong `standardcontrols' [aweight=t39pop] , robust
estimates store drIV, title(" ") 
quietly: reg `x' nazipjmnarrow nazi pj39 pjnarrowmc lnut39pop_59 deglat deglong `standardcontrols' pj89 [aweight=t39pop] , robust
estimates store drV, title(" ") 
quietly: reg `x' dmdthnarrow nazi pj39 lnut39pop_59 deglat deglong `standardcontrols' , robust
estimates store drVI, title(" ") 
quietly: reg `x' dmdthnarrow nazi pj39 lnut39pop_59 deglat deglong `standardcontrols' [aweight=t39pop] , robust
estimates store drVII, title(" ") 
quietly: reg `x' dmdthnarrow nazi pj39 lnut39pop_59 deglat deglong `standardcontrols' pj89 [aweight=t39pop] , robust
estimates store drVIII, title(" ") 
quietly: reg `x' dmdthnarrow nazi pj39 lnut39pop_59 deglat deglong `standardcontrols' dlogpopnazi dlogpop [aweight=t39pop] , robust
estimates store drIX, title(" ")

disp "********************`x'****************************"

estout drI drII drIII drIV drV drVI drVII drVIII drIX using regtemplate2`x'.tex, replace style(tex) ml( ,none) order(nazipj nazipjmnarrow dmdthnarrow) keep(nazipj nazipjmnarrow dmdthnarrow) collabels(, none) label cells(b(nostar fmt(%9.3f)) se(par)) starlevels(+ 0.10 * 0.05 ** 0.01)
quietly: estout drI drII drIII drIV drV drVI drVII drVIII drIX using regtemplate2full`x'.tex, replace style(tex) ml( ,none) order(nazipj  dmdth) drop(_cons ukr bel pol, relax ) collabels(, none) label cells(b(nostar fmt(%9.3f)) se(par)) stats( N, fmt( %9.0g)labels( "N")) starlevels(+ 0.10 * 0.05 ** 0.01)
} 


**Table A.6

reg lnm89 nazipj37 nazi pj37 lnut39pop_59 deglat deglong lnm39abs oil delta_em_imp delta_ed_imp lnpop89 if pj39!=., robust
estimates store drI, title(" ") 
reg lnm89 nazipj37 nazi pj37 lnut39pop_59 deglat deglong lnm39abs oil delta_em_imp delta_ed_imp  lnpop89  [aweight=t39pop] if pj39!=. , robust
estimates store drII, title(" ") 
reg lnm89 dmdthnarrow37 nazi pj37 lnut39pop_59 deglat deglong lnm39abs oil delta_em_imp delta_ed_imp  lnpop89 , robust
estimates store drIII, title(" ") 
reg lnm89 dmdthnarrow37 nazi pj37 lnut39pop_59 deglat deglong lnm39abs oil delta_em_imp delta_ed_imp  lnpop89 [aweight=t39pop] , robust
estimates store drIV, title(" ") 
reg lnm89 dmdthnarrow37 nazi pj37 lnut39pop_59 deglat deglong lnm39abs oil delta_em_imp delta_ed_imp  lnpop89 pj89 [aweight=t39pop], robust
estimates store drV, title(" ") 
reg lnm89 dmdthnarrow37 nazi pj37 lnut39pop_59 deglat deglong lnm39abs oil delta_em_imp delta_ed_imp  lnpop89 dlogpopnazi dlogpop [aweight=t39pop], robust
estimates store drVI, title(" ") 

estout drI drII drIII drIV drV drVI using regtemplate2lnm8937.tex, replace style(tex) ml( ,none) keep(nazipj37 dmdthnarrow37) order(nazipj37 deltapj37 dmdth37) drop(_cons  lnm39abs oil  nazi `interaction' pj39 pj89  lnue89 nazidur deglong deglat lnut39pop_59 lnpop39_59 dlogpop pj89, relax) collabels(, none) label cells(b(nostar fmt(%9.3f)) se(par)) stats( N, fmt( %9.0g)labels( "N")) starlevels(+ 0.10 * 0.05 ** 0.01)
quietly: estout drI drII drIII drIV drV drVI using regtemplate2fulllnm8937.tex, replace style(tex) ml( ,none) order(nazipj37 deltapj37 dmdth37) drop(_cons  ) collabels(, none) label cells(b(nostar fmt(%9.3f)) se(par)) stats(r2_a N, fmt(%9.3f %9.0g)labels("\$R^2\$" "N")) starlevels(+ 0.10 * 0.05 ** 0.01)

quietly: reg lnm89 nazipj37 nazi pj37 lnut39pop_59 deglat deglong lnm39abs oil delta_em_imp delta_ed_imp lnpop89 if pj37alt!=., robust
estimates store drI, title(" ") 
quietly: reg lnm89 nazipj37 nazi pj37 lnut39pop_59 deglat deglong lnm39abs oil delta_em_imp delta_ed_imp lnpop89 [aweight=t39pop] if pj37alt!=., robust
estimates store drII, title(" ") 
quietly: reg lnm89 dmdthnarrow37 nazi pj37 lnut39pop_59 deglat deglong lnm39abs oil delta_em_imp delta_ed_imp lnpop89 if pj37alt!=., robust
estimates store drIII, title(" ") 
quietly: reg lnm89 dmdthnarrow37 nazi pj37 lnut39pop_59 deglat deglong lnm39abs oil delta_em_imp delta_ed_imp lnpop89 [aweight=t39pop] if pj37alt!=., robust
estimates store drIV, title(" ") 
quietly: reg lnm89 dmdthnarrow37 nazi pj37 lnut39pop_59 deglat deglong lnm39abs oil delta_em_imp delta_ed_imp lnpop89 pj89 if pj37alt!=. [aweight=t39pop], robust
estimates store drV, title(" ")
quietly: reg lnm89 dmdthnarrow37 nazi pj37 lnut39pop_59 deglat deglong lnm39abs oil delta_em_imp delta_ed_imp lnpop89 dlogpopnazi dlogpop if pj37alt!=. [aweight=t39pop], robust
estimates store drVI, title(" ") 

estout drI drII drIII drIV drV drVI using regtemplate2lnm8937exclusive.tex, replace style(tex) ml( ,none) keep(nazipj37 dmdthnarrow37)  collabels(, none) label cells(b(nostar fmt(%9.3f)) se(par)) stats( N, fmt( %9.0g)labels( "N")) starlevels(+ 0.10 * 0.05 ** 0.01)
quietly: estout drI drII drIII drIV drV drVI using regtemplate2fulllnm8937exclusive.tex, replace style(tex) ml( ,none) drop(_cons  ) collabels(, none) label cells(b(nostar fmt(%9.3f)) se(par)) stats(r2_a N, fmt(%9.3f %9.0g)labels("\$R^2\$" "N")) starlevels(+ 0.10 * 0.05 ** 0.01)


**Figure V

reg lnreferendum dmdthnarrow nazi pj39 lnut39pop_59 deglat deglong lnm39abs oil  delta_em_imp delta_ed_imp [aweight=t39pop] , robust
avplot dmdthnarrow, mlab(oblastname) msize(small) mlabsize(vsmall)  mlabcolor(gs9) ytitle(Log % Votes in Favor of Preserving S.U.)xtitle(Ex-post Impact on Middle Class)scheme(s2mono)
graph export lnreferendumdmdth.eps,replace


